/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import java.time.Duration;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.TimestampAssignerSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.connector.source.ReaderOutput;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.source.NoOpTimestampsAndWatermarks;
import org.apache.flink.streaming.api.operators.source.ProgressiveTimestampsAndWatermarks;
import org.apache.flink.streaming.api.operators.source.TimestampsAndWatermarksContext;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public interface TimestampsAndWatermarks<T> {
    public ReaderOutput<T> createMainOutput(PushingAsyncDataInput.DataOutput<T> var1, WatermarkUpdateListener var2);

    public void startPeriodicWatermarkEmits();

    public void stopPeriodicWatermarkEmits();

    public static <E> TimestampsAndWatermarks<E> createProgressiveEventTimeLogic(WatermarkStrategy<E> watermarkStrategy, MetricGroup metrics, ProcessingTimeService timeService, long periodicWatermarkIntervalMillis) {
        TimestampsAndWatermarksContext context = new TimestampsAndWatermarksContext(metrics);
        TimestampAssigner timestampAssigner = watermarkStrategy.createTimestampAssigner((TimestampAssignerSupplier.Context)context);
        return new ProgressiveTimestampsAndWatermarks<E>(timestampAssigner, watermarkStrategy, context, timeService, Duration.ofMillis(periodicWatermarkIntervalMillis));
    }

    public static <E> TimestampsAndWatermarks<E> createNoOpEventTimeLogic(WatermarkStrategy<E> watermarkStrategy, MetricGroup metrics) {
        TimestampsAndWatermarksContext context = new TimestampsAndWatermarksContext(metrics);
        TimestampAssigner timestampAssigner = watermarkStrategy.createTimestampAssigner((TimestampAssignerSupplier.Context)context);
        return new NoOpTimestampsAndWatermarks(timestampAssigner);
    }

    @Internal
    public static interface WatermarkUpdateListener {
        public void updateIdle(boolean var1);

        public void updateCurrentEffectiveWatermark(long var1);
    }
}

