/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.util.Preconditions;

class SocketConnection
implements AutoCloseable {
    private final Socket socket;
    private final DataInputViewStreamWrapper inStream;
    private final DataOutputViewStreamWrapper outStream;

    public static SocketConnection create(int socketTimeout, InetSocketAddress address) throws IOException {
        Socket newSocket = new Socket();
        newSocket.setSoTimeout(socketTimeout);
        newSocket.setKeepAlive(true);
        newSocket.setTcpNoDelay(true);
        newSocket.connect(address);
        return new SocketConnection(newSocket);
    }

    @VisibleForTesting
    SocketConnection(Socket connectedSocket) throws IOException {
        Preconditions.checkArgument((boolean)connectedSocket.isConnected());
        this.socket = connectedSocket;
        this.inStream = new DataInputViewStreamWrapper(this.socket.getInputStream());
        this.outStream = new DataOutputViewStreamWrapper(this.socket.getOutputStream());
    }

    public DataInputView getDataInputView() {
        return this.inStream;
    }

    public DataOutputView getDataOutputView() {
        return this.outStream;
    }

    @Override
    public void close() throws Exception {
        this.outStream.close();
        this.inStream.close();
        this.socket.close();
    }
}

