/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.partitioner;

import java.io.IOException;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class StreamPartitionerTest
extends TestLogger {
    protected final StreamPartitioner<Tuple> streamPartitioner = this.createPartitioner();
    protected final StreamRecord<Tuple> streamRecord = new StreamRecord(null);
    protected final SerializationDelegate<StreamRecord<Tuple>> serializationDelegate = new SerializationDelegate(null);

    abstract StreamPartitioner<Tuple> createPartitioner();

    @Before
    public void setup() {
        this.serializationDelegate.setInstance(this.streamRecord);
    }

    protected void assertSelectedChannel(int expectedChannel) {
        int actualResult = this.streamPartitioner.selectChannel(this.serializationDelegate);
        Assert.assertEquals((long)expectedChannel, (long)actualResult);
    }

    protected void assertSelectedChannelWithSetup(int expectedChannel, int numberOfChannels) {
        this.streamPartitioner.setup(numberOfChannels);
        this.assertSelectedChannel(expectedChannel);
    }

    @Test
    public void testSerializable() throws IOException, ClassNotFoundException {
        StreamPartitioner clone = (StreamPartitioner)InstantiationUtil.clone(this.streamPartitioner);
        Assert.assertEquals(this.streamPartitioner, (Object)clone);
    }
}

