/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.watermarkstatus.WatermarkStatus;
import org.apache.flink.streaming.util.AbstractStreamOperatorTestHarness;

public class TwoInputStreamOperatorTestHarness<IN1, IN2, OUT>
extends AbstractStreamOperatorTestHarness<OUT> {
    private final TwoInputStreamOperator<IN1, IN2, OUT> twoInputOperator;

    public TwoInputStreamOperatorTestHarness(TwoInputStreamOperator<IN1, IN2, OUT> operator) throws Exception {
        this(operator, 1, 1, 0);
    }

    public TwoInputStreamOperatorTestHarness(TwoInputStreamOperator<IN1, IN2, OUT> operator, int maxParallelism, int numSubtasks, int subtaskIndex) throws Exception {
        super(operator, maxParallelism, numSubtasks, subtaskIndex);
        this.twoInputOperator = operator;
    }

    public void processElement1(StreamRecord<IN1> element) throws Exception {
        this.twoInputOperator.setKeyContextElement1(element);
        this.twoInputOperator.processElement1(element);
    }

    public void processElement1(IN1 value, long timestamp) throws Exception {
        this.processElement1(new StreamRecord(value, timestamp));
    }

    public void processElement2(StreamRecord<IN2> element) throws Exception {
        this.twoInputOperator.setKeyContextElement2(element);
        this.twoInputOperator.processElement2(element);
    }

    public void processElement2(IN2 value, long timestamp) throws Exception {
        this.processElement2(new StreamRecord(value, timestamp));
    }

    public void processWatermark1(Watermark mark) throws Exception {
        this.twoInputOperator.processWatermark1(mark);
    }

    public void processWatermark2(Watermark mark) throws Exception {
        this.twoInputOperator.processWatermark2(mark);
    }

    public void processBothWatermarks(Watermark mark) throws Exception {
        this.twoInputOperator.processWatermark1(mark);
        this.twoInputOperator.processWatermark2(mark);
    }

    public void processWatermarkStatus1(WatermarkStatus watermarkStatus) throws Exception {
        this.twoInputOperator.processWatermarkStatus1(watermarkStatus);
    }

    public void processWatermarkStatus2(WatermarkStatus watermarkStatus) throws Exception {
        this.twoInputOperator.processWatermarkStatus2(watermarkStatus);
    }
}

