/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.functions.co.BroadcastProcessFunction;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.streaming.api.functions.co.KeyedBroadcastProcessFunction;
import org.apache.flink.streaming.api.functions.co.KeyedCoProcessFunction;
import org.apache.flink.streaming.util.BroadcastOperatorTestHarness;
import org.apache.flink.streaming.util.KeyedBroadcastOperatorTestHarness;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.KeyedTwoInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.ProcessFunctionTestHarnesses;
import org.apache.flink.streaming.util.TwoInputStreamOperatorTestHarness;
import org.apache.flink.util.Collector;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class ProcessFunctionTestHarnessesTest
extends TestLogger {
    @Test
    public void testHarnessForProcessFunction() throws Exception {
        ProcessFunction<Integer, Integer> function = new ProcessFunction<Integer, Integer>(){

            public void processElement(Integer value, ProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }
        };
        OneInputStreamOperatorTestHarness<Integer, Integer> harness = ProcessFunctionTestHarnesses.forProcessFunction(function);
        harness.processElement(1, 10L);
        Assert.assertEquals(harness.extractOutputValues(), Collections.singletonList(1));
    }

    @Test
    public void testHarnessForKeyedProcessFunction() throws Exception {
        KeyedProcessFunction<Integer, Integer, Integer> function = new KeyedProcessFunction<Integer, Integer, Integer>(){

            public void processElement(Integer value, KeyedProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }
        };
        KeyedOneInputStreamOperatorTestHarness<Integer, Integer, Integer> harness = ProcessFunctionTestHarnesses.forKeyedProcessFunction(function, (KeySelector & Serializable)x -> x, BasicTypeInfo.INT_TYPE_INFO);
        harness.processElement(1, 10L);
        Assert.assertEquals(harness.extractOutputValues(), Collections.singletonList(1));
    }

    @Test
    public void testHarnessForCoProcessFunction() throws Exception {
        CoProcessFunction<Integer, String, Integer> function = new CoProcessFunction<Integer, String, Integer>(){

            public void processElement1(Integer value, CoProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }

            public void processElement2(String value, CoProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)Integer.parseInt(value));
            }
        };
        TwoInputStreamOperatorTestHarness<Integer, String, Integer> harness = ProcessFunctionTestHarnesses.forCoProcessFunction(function);
        harness.processElement2("0", 1L);
        harness.processElement1(1, 10L);
        Assert.assertEquals(harness.extractOutputValues(), Arrays.asList(0, 1));
    }

    @Test
    public void testHarnessForKeyedCoProcessFunction() throws Exception {
        KeyedCoProcessFunction<Integer, Integer, Integer, Integer> function = new KeyedCoProcessFunction<Integer, Integer, Integer, Integer>(){

            public void processElement1(Integer value, KeyedCoProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }

            public void processElement2(Integer value, KeyedCoProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }
        };
        KeyedTwoInputStreamOperatorTestHarness<Integer, Integer, Integer, Integer> harness = ProcessFunctionTestHarnesses.forKeyedCoProcessFunction(function, (KeySelector & Serializable)x -> x, (KeySelector & Serializable)x -> x, TypeInformation.of(Integer.class));
        harness.processElement1(0, 1L);
        harness.processElement2(1, 10L);
        Assert.assertEquals(harness.extractOutputValues(), Arrays.asList(0, 1));
    }

    @Test
    public void testHarnessForBroadcastProcessFunction() throws Exception {
        BroadcastProcessFunction<Integer, String, Integer> function = new BroadcastProcessFunction<Integer, String, Integer>(){

            public void processElement(Integer value, BroadcastProcessFunction.ReadOnlyContext ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }

            public void processBroadcastElement(String value, BroadcastProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)Integer.parseInt(value));
            }
        };
        BroadcastOperatorTestHarness<Integer, String, Integer> harness = ProcessFunctionTestHarnesses.forBroadcastProcessFunction(function, new MapStateDescriptor[0]);
        harness.processBroadcastElement("0", 1L);
        harness.processElement(1, 10L);
        Assert.assertEquals(harness.extractOutputValues(), Arrays.asList(0, 1));
    }

    @Test
    public void testHarnessForKeyedBroadcastProcessFunction() throws Exception {
        KeyedBroadcastProcessFunction<Integer, Integer, String, Integer> function = new KeyedBroadcastProcessFunction<Integer, Integer, String, Integer>(){

            public void processElement(Integer value, KeyedBroadcastProcessFunction.ReadOnlyContext ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)value);
            }

            public void processBroadcastElement(String value, KeyedBroadcastProcessFunction.Context ctx, Collector<Integer> out) throws Exception {
                out.collect((Object)Integer.parseInt(value));
            }
        };
        MapStateDescriptor stateDescriptor = new MapStateDescriptor("keys", (TypeInformation)BasicTypeInfo.INT_TYPE_INFO, (TypeInformation)BasicTypeInfo.STRING_TYPE_INFO);
        KeyedBroadcastOperatorTestHarness<Integer, Integer, String, Integer> harness = ProcessFunctionTestHarnesses.forKeyedBroadcastProcessFunction(function, (KeySelector & Serializable)x -> x, TypeInformation.of(Integer.class), stateDescriptor);
        harness.processBroadcastElement("0", 1L);
        harness.processElement(1, 10L);
        Assert.assertEquals(harness.extractOutputValues(), Arrays.asList(0, 1));
    }
}

