/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.collect.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.streaming.api.operators.collect.CollectCoordinationResponse;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class CollectTestUtils {
    public static <T> List<byte[]> toBytesList(List<T> values, TypeSerializer<T> serializer) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        for (T value : values) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputViewStreamWrapper wrapper = new DataOutputViewStreamWrapper((OutputStream)baos);
            try {
                serializer.serialize(value, (DataOutputView)wrapper);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ret.add(baos.toByteArray());
        }
        return ret;
    }

    public static <T> void assertResponseEquals(CollectCoordinationResponse response, String version, long lastCheckpointedOffset, List<T> expected, TypeSerializer<T> serializer) throws IOException {
        Assert.assertEquals((Object)version, (Object)response.getVersion());
        Assert.assertEquals((long)lastCheckpointedOffset, (long)response.getLastCheckpointedOffset());
        List results = response.getResults(serializer);
        CollectTestUtils.assertResultsEqual(expected, results);
    }

    public static <T> void assertResultsEqual(List<T> expected, List<T> actual) {
        Assert.assertThat(actual, (Matcher)CoreMatchers.is(expected));
    }

    public static <T> void assertAccumulatorResult(Tuple2<Long, CollectCoordinationResponse> accResults, long expectedOffset, String expectedVersion, long expectedLastCheckpointedOffset, List<T> expectedResults, TypeSerializer<T> serializer) throws Exception {
        long offset = (Long)accResults.f0;
        CollectCoordinationResponse response = (CollectCoordinationResponse)accResults.f1;
        List actualResults = response.getResults(serializer);
        Assert.assertEquals((long)expectedOffset, (long)offset);
        Assert.assertEquals((Object)expectedVersion, (Object)response.getVersion());
        Assert.assertEquals((long)expectedLastCheckpointedOffset, (long)response.getLastCheckpointedOffset());
        CollectTestUtils.assertResultsEqual(expectedResults, actualResults);
    }
}

