/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.PhysicalTransformation;

@Internal
public final class ReduceTransformation<IN, K>
extends PhysicalTransformation<IN> {
    private final Transformation<IN> input;
    private final ReduceFunction<IN> reducer;
    private final KeySelector<IN, K> keySelector;
    private final TypeInformation<K> keyTypeInfo;
    private ChainingStrategy chainingStrategy = ChainingStrategy.DEFAULT_CHAINING_STRATEGY;

    public ReduceTransformation(String name, int parallelism, Transformation<IN> input, ReduceFunction<IN> reducer, KeySelector<IN, K> keySelector, TypeInformation<K> keyTypeInfo) {
        super(name, input.getOutputType(), parallelism);
        this.input = input;
        this.reducer = reducer;
        this.keySelector = keySelector;
        this.keyTypeInfo = keyTypeInfo;
        this.updateManagedMemoryStateBackendUseCase(true);
    }

    @Override
    public void setChainingStrategy(ChainingStrategy strategy) {
        this.chainingStrategy = strategy;
    }

    public ChainingStrategy getChainingStrategy() {
        return this.chainingStrategy;
    }

    public KeySelector<IN, K> getKeySelector() {
        return this.keySelector;
    }

    public TypeInformation<K> getKeyTypeInfo() {
        return this.keyTypeInfo;
    }

    public ReduceFunction<IN> getReducer() {
        return this.reducer;
    }

    public TypeInformation<IN> getInputType() {
        return this.input.getOutputType();
    }

    public List<Transformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    public List<Transformation<?>> getInputs() {
        return Collections.singletonList(this.input);
    }
}

