/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.Closeable;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.Internal;
import org.apache.flink.contrib.streaming.state.RocksDBNativeMetricOptions;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.View;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Statistics;
import org.rocksdb.TickerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class RocksDBNativeMetricMonitor
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(RocksDBNativeMetricMonitor.class);
    private final RocksDBNativeMetricOptions options;
    private final MetricGroup metricGroup;
    private final Object lock;
    static final String COLUMN_FAMILY_KEY = "column_family";
    @GuardedBy(value="lock")
    private RocksDB rocksDB;
    @Nullable
    @GuardedBy(value="lock")
    private Statistics statistics;

    public RocksDBNativeMetricMonitor(@Nonnull RocksDBNativeMetricOptions options, @Nonnull MetricGroup metricGroup, @Nonnull RocksDB rocksDB, @Nullable Statistics statistics) {
        this.options = options;
        this.metricGroup = metricGroup;
        this.rocksDB = rocksDB;
        this.statistics = statistics;
        this.lock = new Object();
        this.registerStatistics();
    }

    private void registerStatistics() {
        if (this.statistics != null) {
            for (TickerType tickerType : this.options.getMonitorTickerTypes()) {
                this.metricGroup.gauge(String.format("rocksdb.%s", tickerType.name().toLowerCase()), (Gauge)new RocksDBNativeStatisticsMetricView(tickerType));
            }
        }
    }

    void registerColumnFamily(String columnFamilyName, ColumnFamilyHandle handle) {
        boolean columnFamilyAsVariable = this.options.isColumnFamilyAsVariable();
        MetricGroup group = columnFamilyAsVariable ? this.metricGroup.addGroup(COLUMN_FAMILY_KEY, columnFamilyName) : this.metricGroup.addGroup(columnFamilyName);
        for (String property : this.options.getProperties()) {
            RocksDBNativePropertyMetricView gauge = new RocksDBNativePropertyMetricView(handle, property);
            group.gauge(property, (Gauge)gauge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProperty(RocksDBNativePropertyMetricView metricView) {
        if (metricView.isClosed()) {
            return;
        }
        try {
            Object object = this.lock;
            synchronized (object) {
                if (this.rocksDB != null) {
                    long value = this.rocksDB.getLongProperty(metricView.handle, metricView.property);
                    metricView.setValue(value);
                }
            }
        }
        catch (RocksDBException e) {
            metricView.close();
            LOG.warn("Failed to read native metric {} from RocksDB.", (Object)metricView.property, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatistics(RocksDBNativeStatisticsMetricView metricView) {
        if (metricView.isClosed()) {
            return;
        }
        if (this.statistics != null) {
            Object object = this.lock;
            synchronized (object) {
                metricView.setValue(this.statistics.getTickerCount(metricView.tickerType));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.rocksDB = null;
            this.statistics = null;
        }
    }

    class RocksDBNativeStatisticsMetricView
    extends RocksDBNativeView
    implements Gauge<Long> {
        private final TickerType tickerType;
        private long value;

        private RocksDBNativeStatisticsMetricView(TickerType tickerType) {
            this.tickerType = tickerType;
        }

        public Long getValue() {
            return this.value;
        }

        void setValue(long value) {
            this.value = value;
        }

        public void update() {
            RocksDBNativeMetricMonitor.this.setStatistics(this);
        }
    }

    class RocksDBNativePropertyMetricView
    extends RocksDBNativeView
    implements Gauge<BigInteger> {
        private final String property;
        private final ColumnFamilyHandle handle;
        private BigInteger bigInteger;

        private RocksDBNativePropertyMetricView(@Nonnull ColumnFamilyHandle handle, String property) {
            this.handle = handle;
            this.property = property;
            this.bigInteger = BigInteger.ZERO;
        }

        public void setValue(long value) {
            if (value >= 0L) {
                this.bigInteger = BigInteger.valueOf(value);
            } else {
                int upper = (int)(value >>> 32);
                int lower = (int)value;
                this.bigInteger = BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
            }
        }

        public BigInteger getValue() {
            return this.bigInteger;
        }

        public void update() {
            RocksDBNativeMetricMonitor.this.setProperty(this);
        }
    }

    static abstract class RocksDBNativeView
    implements View {
        private boolean closed = false;

        RocksDBNativeView() {
        }

        void close() {
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }
    }
}

