/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.contrib.streaming.state.RocksDBConfigurableOptions;
import org.apache.flink.util.CollectionUtil;
import org.rocksdb.CompactionStyle;

public enum PredefinedOptions {
    DEFAULT(Collections.emptyMap()),
    SPINNING_DISK_OPTIMIZED(new HashMap<ConfigOption<?>, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(RocksDBConfigurableOptions.COMPACTION_STYLE, CompactionStyle.LEVEL);
            this.put(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE, true);
            this.put(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS, 4);
            this.put(RocksDBConfigurableOptions.MAX_OPEN_FILES, -1);
        }
    }),
    SPINNING_DISK_OPTIMIZED_HIGH_MEM(new HashMap<ConfigOption<?>, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(RocksDBConfigurableOptions.BLOCK_CACHE_SIZE, MemorySize.parse((String)"256mb"));
            this.put(RocksDBConfigurableOptions.BLOCK_SIZE, MemorySize.parse((String)"128kb"));
            this.put(RocksDBConfigurableOptions.USE_DYNAMIC_LEVEL_SIZE, true);
            this.put(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS, 4);
            this.put(RocksDBConfigurableOptions.MAX_SIZE_LEVEL_BASE, MemorySize.parse((String)"1gb"));
            this.put(RocksDBConfigurableOptions.MAX_OPEN_FILES, -1);
            this.put(RocksDBConfigurableOptions.MAX_WRITE_BUFFER_NUMBER, 4);
            this.put(RocksDBConfigurableOptions.MIN_WRITE_BUFFER_NUMBER_TO_MERGE, 3);
            this.put(RocksDBConfigurableOptions.TARGET_FILE_SIZE_BASE, MemorySize.parse((String)"256mb"));
            this.put(RocksDBConfigurableOptions.WRITE_BUFFER_SIZE, MemorySize.parse((String)"64mb"));
            this.put(RocksDBConfigurableOptions.USE_BLOOM_FILTER, true);
        }
    }),
    FLASH_SSD_OPTIMIZED(new HashMap<ConfigOption<?>, Object>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(RocksDBConfigurableOptions.MAX_BACKGROUND_THREADS, 4);
            this.put(RocksDBConfigurableOptions.MAX_OPEN_FILES, -1);
        }
    });

    private final Map<String, Object> options;

    private PredefinedOptions(Map<ConfigOption<?>, Object> initMap) {
        this.options = CollectionUtil.newHashMapWithExpectedSize((int)initMap.size());
        for (Map.Entry<ConfigOption<?>, Object> entry : initMap.entrySet()) {
            this.options.put(entry.getKey().key(), entry.getValue());
        }
    }

    @Nullable
    <T> T getValue(ConfigOption<T> option) {
        Object value = this.options.get(option.key());
        if (value == null) {
            value = option.defaultValue();
        }
        if (value == null) {
            return null;
        }
        return (T)value;
    }
}

