/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog.restore;

import java.util.List;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalListState;
import org.apache.flink.state.changelog.StateChangeOperation;
import org.apache.flink.state.changelog.restore.KvStateChangeApplier;

class ListStateChangeApplier<K, N, T>
extends KvStateChangeApplier<K, N> {
    private final InternalListState<K, N, T> state;

    protected ListStateChangeApplier(InternalKeyContext<K> keyContext, InternalListState<K, N, T> state) {
        super(keyContext);
        this.state = state;
    }

    @Override
    protected InternalKvState<K, N, ?> getState() {
        return this.state;
    }

    @Override
    protected void applyInternal(StateChangeOperation operation, DataInputView in) throws Exception {
        switch (operation) {
            case ADD: {
                this.state.addAll((List)this.state.getValueSerializer().deserialize(in));
                break;
            }
            case ADD_ELEMENT: {
                this.state.add(((ListSerializer)this.state.getValueSerializer()).getElementSerializer().deserialize(in));
                break;
            }
            case SET: {
                this.state.update((List)this.state.getValueSerializer().deserialize(in));
                break;
            }
            case SET_INTERNAL: {
                this.state.updateInternal(this.state.getValueSerializer().deserialize(in));
                break;
            }
            case MERGE_NS: {
                ListStateChangeApplier.applyMergeNamespaces(this.state, in);
                break;
            }
            case CLEAR: {
                this.state.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown state change operation: " + (Object)((Object)operation));
            }
        }
    }
}

