/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import org.apache.flink.api.common.state.State;
import org.apache.flink.runtime.state.InternalKeyContext;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.runtime.state.internal.InternalValueState;
import org.apache.flink.state.changelog.AbstractChangelogState;
import org.apache.flink.state.changelog.KvStateChangeLogger;
import org.apache.flink.state.changelog.restore.ChangelogApplierFactory;
import org.apache.flink.state.changelog.restore.StateChangeApplier;
import org.apache.flink.util.ExceptionUtils;

class ChangelogValueState<K, N, V>
extends AbstractChangelogState<K, N, V, InternalValueState<K, N, V>>
implements InternalValueState<K, N, V> {
    private final InternalKeyContext<K> keyContext;

    ChangelogValueState(InternalValueState<K, N, V> delegatedState, KvStateChangeLogger<V, N> changeLogger, InternalKeyContext<K> keyContext) {
        super(delegatedState, changeLogger);
        this.keyContext = keyContext;
    }

    public V value() throws IOException {
        return (V)((InternalValueState)this.delegatedState).value();
    }

    public void update(V value) throws IOException {
        ((InternalValueState)this.delegatedState).update(value);
        this.changeLogger.valueUpdated(value, this.getCurrentNamespace());
    }

    public void clear() {
        ((InternalValueState)this.delegatedState).clear();
        try {
            this.changeLogger.valueCleared(this.getCurrentNamespace());
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    static <K, N, SV, S extends State, IS extends S> IS create(InternalKvState<K, N, SV> valueState, KvStateChangeLogger<SV, N> changeLogger, InternalKeyContext<K> keyContext) {
        return (IS)new ChangelogValueState<K, N, SV>((InternalValueState)valueState, changeLogger, keyContext);
    }

    @Override
    public StateChangeApplier getChangeApplier(ChangelogApplierFactory factory) {
        return factory.forValue((InternalValueState)this.delegatedState, this.keyContext);
    }
}

