/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.state.changelog.StateChangeLogger;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.BiConsumerWithException;
import org.apache.flink.util.function.ThrowingConsumer;

class StateChangeLoggingIterator<State, StateElement, Namespace>
implements CloseableIterator<StateElement> {
    private final CloseableIterator<StateElement> iterator;
    private final StateChangeLogger<State, Namespace> changeLogger;
    private final BiConsumerWithException<StateElement, DataOutputViewStreamWrapper, IOException> removalWriter;
    private final Namespace ns;
    @Nullable
    private StateElement lastReturned;

    private StateChangeLoggingIterator(CloseableIterator<StateElement> iterator, StateChangeLogger<State, Namespace> changeLogger, BiConsumerWithException<StateElement, DataOutputViewStreamWrapper, IOException> removalWriter, Namespace ns) {
        this.iterator = iterator;
        this.changeLogger = changeLogger;
        this.removalWriter = removalWriter;
        this.ns = ns;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public StateElement next() {
        this.lastReturned = this.iterator.next();
        return this.lastReturned;
    }

    public void remove() {
        this.iterator.remove();
        try {
            this.changeLogger.valueElementRemoved((ThrowingConsumer<DataOutputViewStreamWrapper, IOException>)((ThrowingConsumer)out -> this.removalWriter.accept(this.lastReturned, out)), this.ns);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    @Nonnull
    public static <Namespace, State, StateElement> CloseableIterator<StateElement> create(CloseableIterator<StateElement> iterator, StateChangeLogger<State, Namespace> changeLogger, BiConsumerWithException<StateElement, DataOutputViewStreamWrapper, IOException> removalWriter, Namespace ns) {
        return new StateChangeLoggingIterator<State, StateElement, Namespace>(iterator, changeLogger, removalWriter, ns);
    }

    public void close() throws Exception {
        this.iterator.close();
    }
}

