/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.changelog;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.RegisteredPriorityQueueStateBackendMetaInfo;
import org.apache.flink.runtime.state.RegisteredStateMetaInfoBase;
import org.apache.flink.runtime.state.changelog.StateChangelogWriter;
import org.apache.flink.runtime.state.heap.InternalKeyContext;
import org.apache.flink.state.changelog.AbstractStateChangeLogger;
import org.apache.flink.util.Preconditions;

class PriorityQueueStateChangeLoggerImpl<K, T>
extends AbstractStateChangeLogger<K, T, Void> {
    private TypeSerializer<T> serializer;

    PriorityQueueStateChangeLoggerImpl(TypeSerializer<T> serializer, InternalKeyContext<K> keyContext, StateChangelogWriter<?> stateChangelogWriter, RegisteredPriorityQueueStateBackendMetaInfo<T> meta, short stateId) {
        super(stateChangelogWriter, keyContext, (RegisteredStateMetaInfoBase)meta, stateId);
        this.serializer = (TypeSerializer)Preconditions.checkNotNull(serializer);
    }

    @Override
    protected void serializeValue(T t, DataOutputViewStreamWrapper out) throws IOException {
        this.serializer.serialize(t, (DataOutputView)out);
    }

    @Override
    protected void serializeScope(Void unused, DataOutputViewStreamWrapper out) throws IOException {
    }

    protected PriorityQueueStateChangeLoggerImpl<K, T> setMetaInfo(RegisteredStateMetaInfoBase metaInfo) {
        super.setMetaInfo(metaInfo);
        RegisteredPriorityQueueStateBackendMetaInfo pqMetaInfo = (RegisteredPriorityQueueStateBackendMetaInfo)metaInfo;
        this.serializer = pqMetaInfo.getElementSerializer();
        return this;
    }
}

