/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ser.std.StdSerializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.ZonedTimestampType;

@Internal
public final class LogicalTypeJsonSerializer
extends StdSerializer<LogicalType> {
    private static final long serialVersionUID = 1L;
    public static final String FIELD_NAME_TYPE_NAME = "type";
    public static final String FIELD_NAME_NULLABLE = "nullable";
    public static final String FIELD_NAME_LENGTH = "length";
    public static final String FIELD_NAME_PRECISION = "precision";
    public static final String FIELD_NAME_SCALE = "scale";
    public static final String FIELD_NAME_KEY_TYPE = "keyType";
    public static final String FIELD_NAME_VALUE_TYPE = "valueType";
    public static final String FIELD_NAME_ELEMENT_TYPE = "elementType";
    public static final String FIELD_NAME_FIELDS = "fields";
    public static final String FIELD_NAME_FIELD_NAME = "name";
    public static final String FIELD_NAME_FIELD_TYPE = "fieldType";
    public static final String FIELD_NAME_FILED_DESCRIPTION = "description";
    public static final String FIELD_NAME_CLASS = "class";
    public static final String FIELD_NAME_SERIALIZER = "serializer";

    public LogicalTypeJsonSerializer() {
        super(LogicalType.class);
    }

    public void serialize(LogicalType logicalType, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.serializeInternal(logicalType, jsonGenerator);
    }

    private void serializeInternal(LogicalType logicalType, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(FIELD_NAME_TYPE_NAME, logicalType.getTypeRoot().name());
        if (logicalType instanceof NullType) {
            jsonGenerator.writeEndObject();
            return;
        }
        jsonGenerator.writeBooleanField(FIELD_NAME_NULLABLE, logicalType.isNullable());
        switch (logicalType.getTypeRoot()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DATE: {
                break;
            }
            case CHAR: {
                jsonGenerator.writeNumberField(FIELD_NAME_LENGTH, ((CharType)logicalType).getLength());
                break;
            }
            case VARCHAR: {
                jsonGenerator.writeNumberField(FIELD_NAME_LENGTH, ((VarCharType)logicalType).getLength());
                break;
            }
            case BINARY: {
                jsonGenerator.writeNumberField(FIELD_NAME_LENGTH, ((BinaryType)logicalType).getLength());
                break;
            }
            case VARBINARY: {
                jsonGenerator.writeNumberField(FIELD_NAME_LENGTH, ((VarBinaryType)logicalType).getLength());
                break;
            }
            case DECIMAL: {
                jsonGenerator.writeNumberField(FIELD_NAME_PRECISION, ((DecimalType)logicalType).getPrecision());
                jsonGenerator.writeNumberField(FIELD_NAME_SCALE, ((DecimalType)logicalType).getScale());
                break;
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                this.serializeTime(logicalType, jsonGenerator);
                break;
            }
            case MAP: {
                this.serializeMap((MapType)logicalType, jsonGenerator);
                break;
            }
            case ARRAY: {
                this.serializeCollection(((ArrayType)logicalType).getElementType(), jsonGenerator);
                break;
            }
            case MULTISET: {
                this.serializeCollection(((MultisetType)logicalType).getElementType(), jsonGenerator);
                break;
            }
            case ROW: {
                this.serializeRow((RowType)logicalType, jsonGenerator);
                break;
            }
            case RAW: {
                if (logicalType instanceof RawType) {
                    this.serializeRaw((RawType)logicalType, jsonGenerator);
                    break;
                }
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unable to serialize logical type '%s'. Please check the documentation for supported types.", logicalType.asSummaryString()));
            }
        }
        jsonGenerator.writeEndObject();
    }

    private void serializeTime(LogicalType timeType, JsonGenerator jsonGenerator) throws IOException {
        switch (timeType.getTypeRoot()) {
            case TIME_WITHOUT_TIME_ZONE: {
                jsonGenerator.writeNumberField(FIELD_NAME_PRECISION, ((TimeType)timeType).getPrecision());
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                jsonGenerator.writeNumberField(FIELD_NAME_PRECISION, ((TimestampType)timeType).getPrecision());
                break;
            }
            case TIMESTAMP_WITH_TIME_ZONE: {
                jsonGenerator.writeNumberField(FIELD_NAME_PRECISION, ((ZonedTimestampType)timeType).getPrecision());
                break;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                jsonGenerator.writeNumberField(FIELD_NAME_PRECISION, ((LocalZonedTimestampType)timeType).getPrecision());
                break;
            }
            default: {
                throw new TableException("Time or time stamp type root expected.");
            }
        }
    }

    private void serializeMap(MapType mapType, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeFieldName(FIELD_NAME_KEY_TYPE);
        this.serializeInternal(mapType.getKeyType(), jsonGenerator);
        jsonGenerator.writeFieldName(FIELD_NAME_VALUE_TYPE);
        this.serializeInternal(mapType.getValueType(), jsonGenerator);
    }

    private void serializeCollection(LogicalType elementType, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeFieldName(FIELD_NAME_ELEMENT_TYPE);
        this.serializeInternal(elementType, jsonGenerator);
    }

    private void serializeRow(RowType rowType, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeArrayFieldStart(FIELD_NAME_FIELDS);
        for (RowType.RowField rowField : rowType.getFields()) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(FIELD_NAME_FIELD_NAME, rowField.getName());
            jsonGenerator.writeFieldName(FIELD_NAME_FIELD_TYPE);
            this.serializeInternal(rowField.getType(), jsonGenerator);
            if (rowField.getDescription().isPresent()) {
                jsonGenerator.writeStringField(FIELD_NAME_FILED_DESCRIPTION, (String)rowField.getDescription().get());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
    }

    private void serializeRaw(RawType<?> rawType, JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeStringField(FIELD_NAME_CLASS, rawType.getOriginatingClass().getName());
        jsonGenerator.writeStringField(FIELD_NAME_SERIALIZER, rawType.getSerializerString());
    }
}

