/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.runtime.util.JvmShutdownSafeguard;
import org.apache.flink.runtime.util.SignalHandler;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpoint;
import org.apache.flink.table.gateway.api.endpoint.SqlGatewayEndpointFactoryUtils;
import org.apache.flink.table.gateway.api.utils.SqlGatewayException;
import org.apache.flink.table.gateway.cli.SqlGatewayOptions;
import org.apache.flink.table.gateway.cli.SqlGatewayOptionsParser;
import org.apache.flink.table.gateway.service.SqlGatewayServiceImpl;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.session.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlGateway {
    private static final Logger LOG = LoggerFactory.getLogger(SqlGateway.class);
    private final List<SqlGatewayEndpoint> endpoints = new ArrayList<SqlGatewayEndpoint>();
    private final Properties dynamicConfig;
    private final CountDownLatch latch;
    private SessionManager sessionManager;

    public SqlGateway(Properties dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
        this.latch = new CountDownLatch(1);
    }

    public void start() throws Exception {
        DefaultContext context = DefaultContext.load(ConfigurationUtils.createConfiguration((Properties)this.dynamicConfig));
        this.sessionManager = new SessionManager(context);
        this.sessionManager.start();
        SqlGatewayServiceImpl sqlGatewayService = new SqlGatewayServiceImpl(this.sessionManager);
        try {
            this.endpoints.addAll(SqlGatewayEndpointFactoryUtils.createSqlGatewayEndpoint(sqlGatewayService, context.getFlinkConfig()));
            for (SqlGatewayEndpoint endpoint : this.endpoints) {
                endpoint.start();
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to start the endpoints.", t);
            throw new SqlGatewayException("Failed to start the endpoints.", t);
        }
    }

    public void stop() {
        for (SqlGatewayEndpoint endpoint : this.endpoints) {
            this.stopEndpointSilently(endpoint);
        }
        if (this.sessionManager != null) {
            this.sessionManager.stop();
        }
        this.latch.countDown();
    }

    public void waitUntilStop() throws Exception {
        this.latch.await();
    }

    public static void main(String[] args) {
        SqlGateway.startSqlGateway(System.out, args);
    }

    @VisibleForTesting
    static void startSqlGateway(PrintStream stream, String[] args) {
        SqlGatewayOptions cliOptions = SqlGatewayOptionsParser.parseSqlGatewayOptions(args);
        if (cliOptions.isPrintHelp()) {
            SqlGatewayOptionsParser.printHelpSqlGateway(stream);
            return;
        }
        EnvironmentInformation.logEnvironmentInfo((Logger)LOG, (String)"SqlGateway", (String[])args);
        SignalHandler.register((Logger)LOG);
        JvmShutdownSafeguard.installAsShutdownHook((Logger)LOG);
        SqlGateway gateway = new SqlGateway(cliOptions.getDynamicConfigs());
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownThread(gateway));
            gateway.start();
            gateway.waitUntilStop();
        }
        catch (Throwable t) {
            if (t instanceof InterruptedException) {
                LOG.info("Caught " + t.getClass().getSimpleName() + ". Shutting down.");
                return;
            }
            stream.println();
            stream.println();
            if (t instanceof SqlGatewayException) {
                throw (SqlGatewayException)t;
            }
            LOG.error("SqlGateway must stop. Unexpected exception. This is a bug. Please consider filing an issue.", t);
            throw new SqlGatewayException("Unexpected exception. This is a bug. Please consider filing an issue.", t);
        }
        finally {
            gateway.stop();
        }
    }

    private void stopEndpointSilently(SqlGatewayEndpoint endpoint) {
        try {
            endpoint.stop();
        }
        catch (Exception e) {
            LOG.error("Failed to stop the endpoint. Ignore.", (Throwable)e);
        }
    }

    private static class ShutdownThread
    extends Thread {
        private final SqlGateway gateway;

        public ShutdownThread(SqlGateway gateway) {
            this.gateway = gateway;
        }

        @Override
        public void run() {
            System.out.println("\nShutting down the Flink SqlGateway...");
            LOG.info("Shutting down the Flink SqlGateway...");
            try {
                this.gateway.stop();
            }
            catch (Exception e) {
                LOG.error("Failed to shut down the Flink SqlGateway: " + e.getMessage(), (Throwable)e);
                System.out.println("Failed to shut down the Flink SqlGateway: " + e.getMessage());
            }
            LOG.info("Flink SqlGateway has been shutdown.");
            System.out.println("Flink SqlGateway has been shutdown.");
        }
    }
}

