/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.service.context;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.flink.client.cli.DefaultCLI;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.config.TableConfigOptions;
import org.apache.flink.table.gateway.api.endpoint.EndpointVersion;
import org.apache.flink.table.gateway.api.session.SessionEnvironment;
import org.apache.flink.table.gateway.api.session.SessionHandle;
import org.apache.flink.table.gateway.api.utils.MockedEndpointVersion;
import org.apache.flink.table.gateway.api.utils.ThreadUtils;
import org.apache.flink.table.gateway.service.context.DefaultContext;
import org.apache.flink.table.gateway.service.context.SessionContext;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class SessionContextTest {
    private static final ExecutorService EXECUTOR_SERVICE = ThreadUtils.newThreadPool((int)5, (int)500, (long)600000L, (String)"session-context-test");
    private SessionContext sessionContext;

    SessionContextTest() {
    }

    @BeforeEach
    public void setup() {
        this.sessionContext = this.createSessionContext();
    }

    @AfterEach
    public void cleanUp() {
        this.sessionContext.close();
    }

    @AfterAll
    public static void closeResources() {
        EXECUTOR_SERVICE.shutdown();
    }

    @Test
    public void testSetAndResetOption() {
        this.sessionContext.set(TableConfigOptions.TABLE_SQL_DIALECT.key(), "hive");
        this.sessionContext.set(PipelineOptions.MAX_PARALLELISM.key(), "128");
        this.sessionContext.set(PipelineOptions.NAME.key(), "test");
        this.sessionContext.set(PipelineOptions.OBJECT_REUSE.key(), "false");
        Assertions.assertThat((String)((String)this.getConfiguration().get(TableConfigOptions.TABLE_SQL_DIALECT))).isEqualTo("hive");
        Assertions.assertThat((Integer)((Integer)this.getConfiguration().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(128);
        Assertions.assertThat((String)((String)this.getConfiguration().get(PipelineOptions.NAME))).isEqualTo("test");
        Assertions.assertThat((Boolean)((Boolean)this.getConfiguration().get(PipelineOptions.OBJECT_REUSE))).isFalse();
        this.sessionContext.reset();
        Assertions.assertThat((String)((String)this.getConfiguration().get(TableConfigOptions.TABLE_SQL_DIALECT))).isEqualTo("default");
        Assertions.assertThat((String)((String)this.getConfiguration().get(PipelineOptions.NAME))).isNull();
        Assertions.assertThat((Integer)((Integer)this.getConfiguration().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(16);
        Assertions.assertThat((Optional)this.getConfiguration().getOptional(PipelineOptions.NAME)).isEmpty();
        Assertions.assertThat((Boolean)((Boolean)this.getConfiguration().get(PipelineOptions.OBJECT_REUSE))).isTrue();
    }

    @Test
    public void testSetAndResetKeyInConfigOptions() {
        this.sessionContext.set(TableConfigOptions.TABLE_SQL_DIALECT.key(), "hive");
        this.sessionContext.set(PipelineOptions.MAX_PARALLELISM.key(), "128");
        this.sessionContext.set(PipelineOptions.NAME.key(), "test");
        this.sessionContext.set(PipelineOptions.OBJECT_REUSE.key(), "false");
        Assertions.assertThat((String)((String)this.getConfiguration().get(TableConfigOptions.TABLE_SQL_DIALECT))).isEqualTo("hive");
        Assertions.assertThat((Integer)((Integer)this.getConfiguration().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(128);
        Assertions.assertThat((String)((String)this.getConfiguration().get(PipelineOptions.NAME))).isEqualTo("test");
        Assertions.assertThat((Boolean)((Boolean)this.getConfiguration().get(PipelineOptions.OBJECT_REUSE))).isFalse();
        this.sessionContext.reset(TableConfigOptions.TABLE_SQL_DIALECT.key());
        Assertions.assertThat((String)((String)this.getConfiguration().get(TableConfigOptions.TABLE_SQL_DIALECT))).isEqualTo("default");
        this.sessionContext.reset(PipelineOptions.MAX_PARALLELISM.key());
        Assertions.assertThat((Integer)((Integer)this.getConfiguration().get(PipelineOptions.MAX_PARALLELISM))).isEqualTo(16);
        this.sessionContext.reset(PipelineOptions.NAME.key());
        Assertions.assertThat((String)((String)this.getConfiguration().get(PipelineOptions.NAME))).isNull();
        this.sessionContext.reset(PipelineOptions.OBJECT_REUSE.key());
        Assertions.assertThat((Boolean)((Boolean)this.getConfiguration().get(PipelineOptions.OBJECT_REUSE))).isTrue();
    }

    @Test
    public void testSetAndResetArbitraryKey() {
        this.sessionContext.set("aa", "11");
        this.sessionContext.set("bb", "22");
        Assertions.assertThat((String)((String)this.sessionContext.getConfigMap().get("aa"))).isEqualTo("11");
        Assertions.assertThat((String)((String)this.sessionContext.getConfigMap().get("bb"))).isEqualTo("22");
        this.sessionContext.reset("aa");
        Assertions.assertThat((String)((String)this.sessionContext.getConfigMap().get("aa"))).isNull();
        Assertions.assertThat((String)((String)this.sessionContext.getConfigMap().get("bb"))).isEqualTo("22");
        this.sessionContext.reset("bb");
        Assertions.assertThat((String)((String)this.sessionContext.getConfigMap().get("bb"))).isNull();
    }

    private SessionContext createSessionContext() {
        Configuration flinkConfig = new Configuration();
        flinkConfig.set(PipelineOptions.OBJECT_REUSE, (Object)true);
        flinkConfig.set(PipelineOptions.MAX_PARALLELISM, (Object)16);
        DefaultContext defaultContext = new DefaultContext(flinkConfig, Collections.singletonList(new DefaultCLI()));
        SessionEnvironment environment = SessionEnvironment.newBuilder().setSessionEndpointVersion((EndpointVersion)MockedEndpointVersion.V1).addSessionConfig(flinkConfig.toMap()).build();
        return SessionContext.create((DefaultContext)defaultContext, (SessionHandle)SessionHandle.create(), (SessionEnvironment)environment, (ExecutorService)EXECUTOR_SERVICE);
    }

    private ReadableConfig getConfiguration() {
        return Configuration.fromMap((Map)this.sessionContext.getConfigMap());
    }
}

