/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest.serde;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.gateway.api.results.ResultSet;
import org.apache.flink.table.gateway.rest.serde.JsonResultSetDeserializer;
import org.apache.flink.table.gateway.rest.serde.JsonResultSetSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonResultSetSerDeTest {
    private static final byte tinyint = 99;
    private static final short smallint = 128;
    private static final int intValue = 45536;
    private static final float floatValue = 33.333f;
    private static final long bigint = 1238123899121L;
    private static final String name = "asdlkjasjkdla998y1122";
    private static final byte[] bytes = new byte[1024];
    private static final Double[] doubles = new Double[]{1.1, 2.2, 3.3};
    private static final BigDecimal decimal = new BigDecimal("123.456789");
    private static final LocalDate date = LocalDate.parse("1990-10-14");
    private static final LocalTime time = LocalTime.parse("12:12:43");
    private static final Timestamp timestamp3 = Timestamp.valueOf("1990-10-14 12:12:43.123");
    private static final Timestamp timestamp9 = Timestamp.valueOf("1990-10-14 12:12:43.123456789");
    private static final Instant timestampWithLocalZone = LocalDateTime.of(1990, 10, 14, 12, 12, 43, 123456789).atOffset(ZoneOffset.of("Z")).toInstant();
    private static final int ROW_NUMBER = 10;
    private static final Map<String, Long> map = new HashMap<String, Long>();
    private static final Map<String, Integer> multiSet = new HashMap<String, Integer>();
    private static final Map<String, Map<String, Integer>> nestedMap = new HashMap<String, Map<String, Integer>>();
    private static final Map<String, Integer> innerMap = new HashMap<String, Integer>();

    JsonResultSetSerDeTest() {
    }

    @Test
    void testSerDeResultSetWithSingleRowData() throws Exception {
        Row row = JsonResultSetSerDeTest.getTestRowData();
        this.seDeResultSet(Collections.singletonList(row), JsonResultSetSerDeTest.getFields());
    }

    @Test
    void testSerDeResultSetWithMultiRowData() throws Exception {
        ArrayList<Row> rowList = new ArrayList<Row>();
        for (int i = 0; i < 10; ++i) {
            rowList.add(JsonResultSetSerDeTest.getTestRowData());
        }
        this.seDeResultSet(rowList, JsonResultSetSerDeTest.getFields());
    }

    @Test
    void testSerDeResultSetWithRowDataNullValues() throws Exception {
        int i;
        ArrayList<Row> rowList = new ArrayList<Row>();
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (i = 0; i < 18; ++i) {
            positions.add(new Random().nextInt(18));
        }
        for (i = 0; i < 10; ++i) {
            rowList.add(JsonResultSetSerDeTest.getTestRowDataWithNullValues(positions));
        }
        this.seDeResultSet(rowList, JsonResultSetSerDeTest.getFields());
    }

    void seDeResultSet(List<Row> rowList, List<DataTypes.Field> fields) throws IOException {
        List rowDataList = rowList.stream().map(JsonResultSetSerDeTest::convertToInternal).collect(Collectors.toList());
        ResolvedSchema testResolvedSchema = JsonResultSetSerDeTest.getTestResolvedSchema(fields);
        ResultSet testResultSet = new ResultSet(ResultSet.ResultType.PAYLOAD, Long.valueOf(0L), testResolvedSchema, rowDataList);
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule resultSetModule = new SimpleModule();
        resultSetModule.addSerializer(ResultSet.class, (JsonSerializer)new JsonResultSetSerializer());
        resultSetModule.addDeserializer(ResultSet.class, (JsonDeserializer)new JsonResultSetDeserializer());
        objectMapper.registerModule((Module)resultSetModule);
        String result = objectMapper.writeValueAsString((Object)testResultSet);
        ResultSet resultSet = (ResultSet)objectMapper.readValue(result, ResultSet.class);
        List deRowDataList = resultSet.getData();
        for (int i = 0; i < deRowDataList.size(); ++i) {
            Assertions.assertThat((Object)JsonResultSetSerDeTest.convertToExternal((RowData)deRowDataList.get(i), DataTypes.ROW(JsonResultSetSerDeTest.getFields()))).isEqualTo((Object)rowList.get(i));
        }
        Assertions.assertThat((String)resultSet.getResultSchema().toString()).isEqualTo(testResultSet.getResultSchema().toString());
    }

    private static ResolvedSchema getTestResolvedSchema(List<DataTypes.Field> fields) {
        List columnNames = fields.stream().map(DataTypes.AbstractField::getName).collect(Collectors.toList());
        List columnDataTypes = fields.stream().map(DataTypes.Field::getDataType).collect(Collectors.toList());
        return ResolvedSchema.physical(columnNames, columnDataTypes);
    }

    private static List<DataTypes.Field> getFields() {
        return Arrays.asList(DataTypes.FIELD((String)"bool", (DataType)DataTypes.BOOLEAN()), DataTypes.FIELD((String)"tinyint", (DataType)DataTypes.TINYINT()), DataTypes.FIELD((String)"smallint", (DataType)DataTypes.SMALLINT()), DataTypes.FIELD((String)"int", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"bigint", (DataType)DataTypes.BIGINT()), DataTypes.FIELD((String)"float", (DataType)DataTypes.FLOAT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING()), DataTypes.FIELD((String)"bytes", (DataType)DataTypes.BYTES()), DataTypes.FIELD((String)"decimal", (DataType)DataTypes.DECIMAL((int)9, (int)6)), DataTypes.FIELD((String)"doubles", (DataType)DataTypes.ARRAY((DataType)DataTypes.DOUBLE())), DataTypes.FIELD((String)"date", (DataType)DataTypes.DATE()), DataTypes.FIELD((String)"time", (DataType)DataTypes.TIME((int)0)), DataTypes.FIELD((String)"timestamp3", (DataType)DataTypes.TIMESTAMP((int)3)), DataTypes.FIELD((String)"timestamp9", (DataType)DataTypes.TIMESTAMP((int)9)), DataTypes.FIELD((String)"timestampWithLocalZone", (DataType)DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)9)), DataTypes.FIELD((String)"map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.BIGINT())), DataTypes.FIELD((String)"multiSet", (DataType)DataTypes.MULTISET((DataType)DataTypes.STRING())), DataTypes.FIELD((String)"map2map", (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.MAP((DataType)DataTypes.STRING(), (DataType)DataTypes.INT()))));
    }

    private static Row getTestRowData() {
        Row testRow = new Row(18);
        JsonResultSetSerDeTest.setRandomKind(testRow);
        testRow.setField(0, (Object)true);
        testRow.setField(1, (Object)99);
        testRow.setField(2, (Object)128);
        testRow.setField(3, (Object)45536);
        testRow.setField(4, (Object)1238123899121L);
        testRow.setField(5, (Object)Float.valueOf(33.333f));
        testRow.setField(6, (Object)name);
        testRow.setField(7, (Object)bytes);
        testRow.setField(8, (Object)decimal);
        testRow.setField(9, (Object)doubles);
        testRow.setField(10, (Object)date);
        testRow.setField(11, (Object)time);
        testRow.setField(12, (Object)timestamp3.toLocalDateTime());
        testRow.setField(13, (Object)timestamp9.toLocalDateTime());
        testRow.setField(14, (Object)timestampWithLocalZone);
        testRow.setField(15, map);
        testRow.setField(16, multiSet);
        testRow.setField(17, nestedMap);
        return testRow;
    }

    private static Row getTestRowDataWithNullValues(List<Integer> positions) {
        Row testRow = new Row(18);
        JsonResultSetSerDeTest.setRandomKind(testRow);
        testRow.setField(0, (Object)true);
        testRow.setField(1, (Object)99);
        testRow.setField(2, (Object)128);
        testRow.setField(3, (Object)45536);
        testRow.setField(4, (Object)1238123899121L);
        testRow.setField(5, (Object)Float.valueOf(33.333f));
        testRow.setField(6, (Object)name);
        testRow.setField(7, (Object)bytes);
        testRow.setField(8, (Object)decimal);
        testRow.setField(9, (Object)doubles);
        testRow.setField(10, (Object)date);
        testRow.setField(11, (Object)time);
        testRow.setField(12, (Object)timestamp3.toLocalDateTime());
        testRow.setField(13, (Object)timestamp9.toLocalDateTime());
        testRow.setField(14, (Object)timestampWithLocalZone);
        testRow.setField(15, map);
        testRow.setField(16, multiSet);
        testRow.setField(17, nestedMap);
        for (int position : positions) {
            testRow.setField(position, null);
        }
        return testRow;
    }

    private static void setRandomKind(Row testRow) {
        int i = new Random().nextInt() % 4;
        switch (i) {
            case 0: {
                testRow.setKind(RowKind.INSERT);
                break;
            }
            case 1: {
                testRow.setKind(RowKind.DELETE);
                break;
            }
            case 2: {
                testRow.setKind(RowKind.UPDATE_AFTER);
                break;
            }
            case 3: {
                testRow.setKind(RowKind.UPDATE_BEFORE);
            }
        }
    }

    private static Row convertToExternal(RowData rowData, DataType dataType) {
        return (Row)DataFormatConverters.getConverterForDataType((DataType)dataType).toExternal((Object)rowData);
    }

    private static GenericRowData convertToInternal(Row row) {
        DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)DataTypes.ROW(JsonResultSetSerDeTest.getFields()));
        return (GenericRowData)converter.toInternal((Object)row);
    }

    static {
        map.put("element", 123L);
        multiSet.put("element", 2);
        innerMap.put("key", 234);
        nestedMap.put("inner_map", innerMap);
        ThreadLocalRandom.current().nextBytes(bytes);
    }
}

