/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.flink.runtime.rest.messages.EmptyMessageParameters;
import org.apache.flink.runtime.rest.messages.EmptyRequestBody;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.table.gateway.rest.RestAPIITTestBase;
import org.apache.flink.table.gateway.rest.header.util.GetApiVersionHeaders;
import org.apache.flink.table.gateway.rest.header.util.GetInfoHeaders;
import org.apache.flink.table.gateway.rest.message.util.GetApiVersionResponseBody;
import org.apache.flink.table.gateway.rest.message.util.GetInfoResponseBody;
import org.apache.flink.table.gateway.rest.util.SqlGatewayRestAPIVersion;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class UtilCaseITTest
extends RestAPIITTestBase {
    private static final GetInfoHeaders getInfoHeaders = GetInfoHeaders.getInstance();
    private static final EmptyRequestBody emptyRequestBody = EmptyRequestBody.getInstance();
    private static final EmptyMessageParameters emptyParameters = EmptyMessageParameters.getInstance();
    private static final GetApiVersionHeaders getApiVersionHeaders = GetApiVersionHeaders.getInstance();

    UtilCaseITTest() {
    }

    @Test
    void testGetInfoAndApiVersion() throws Exception {
        CompletableFuture response = this.sendRequest(getInfoHeaders, emptyParameters, emptyRequestBody);
        String productName = ((GetInfoResponseBody)response.get()).getProductName();
        String version = ((GetInfoResponseBody)response.get()).getProductVersion();
        org.junit.jupiter.api.Assertions.assertEquals((Object)"Apache Flink", (Object)productName);
        org.junit.jupiter.api.Assertions.assertEquals((Object)EnvironmentInformation.getVersion(), (Object)version);
        CompletableFuture response2 = this.sendRequest(getApiVersionHeaders, emptyParameters, emptyRequestBody);
        List versions = ((GetApiVersionResponseBody)response2.get()).getVersions();
        Assertions.assertThat(Arrays.stream(SqlGatewayRestAPIVersion.values()).filter(SqlGatewayRestAPIVersion::isStableVersion).map(Enum::name).collect(Collectors.toList())).isEqualTo((Object)versions);
    }
}

