/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.gateway.rest;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rest.RestClient;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.MessageParameters;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.messages.ResponseBody;
import org.apache.flink.table.gateway.rest.SqlGatewayRestEndpoint;
import org.apache.flink.table.gateway.rest.util.RestConfigUtils;
import org.apache.flink.table.gateway.service.utils.SqlGatewayServiceExtension;
import org.apache.flink.test.junit5.MiniClusterExtension;
import org.apache.flink.util.ExecutorUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.RegisterExtension;

abstract class RestAPIITTestBase {
    @RegisterExtension
    @Order(value=1)
    private static final MiniClusterExtension MINI_CLUSTER = new MiniClusterExtension();
    @RegisterExtension
    @Order(value=2)
    protected static final SqlGatewayServiceExtension SQL_GATEWAY_SERVICE_EXTENSION = new SqlGatewayServiceExtension(() -> ((MiniClusterExtension)MINI_CLUSTER).getClientConfiguration());
    @Nullable
    private static RestClient restClient = null;
    @Nullable
    private static String targetAddress = null;
    @Nullable
    private static ExecutorService executorService = null;
    @Nullable
    private static SqlGatewayRestEndpoint sqlGatewayRestEndpoint = null;
    private static int port = 0;

    RestAPIITTestBase() {
    }

    @BeforeAll
    static void start() throws Exception {
        String address = InetAddress.getLoopbackAddress().getHostAddress();
        Configuration config = RestConfigUtils.getBaseConfig(RestConfigUtils.getFlinkConfig(address, address, "0"));
        sqlGatewayRestEndpoint = new SqlGatewayRestEndpoint(config, SQL_GATEWAY_SERVICE_EXTENSION.getService());
        sqlGatewayRestEndpoint.start();
        InetSocketAddress serverAddress = (InetSocketAddress)Preconditions.checkNotNull((Object)sqlGatewayRestEndpoint.getServerAddress());
        executorService = Executors.newFixedThreadPool(1, (ThreadFactory)new ExecutorThreadFactory("rest-client-thread-pool"));
        restClient = new RestClient(new Configuration(), (Executor)executorService);
        targetAddress = serverAddress.getHostName();
        port = serverAddress.getPort();
    }

    @AfterAll
    static void stop() throws Exception {
        Preconditions.checkNotNull((Object)sqlGatewayRestEndpoint);
        sqlGatewayRestEndpoint.close();
        Preconditions.checkNotNull((Object)restClient);
        restClient.shutdown(Time.seconds((long)3L));
        Preconditions.checkNotNull((Object)executorService);
        ExecutorUtils.gracefulShutdown((long)3L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{executorService});
    }

    public <M extends MessageHeaders<R, P, U>, U extends MessageParameters, R extends RequestBody, P extends ResponseBody> CompletableFuture<P> sendRequest(M messageHeaders, U messageParameters, R request) throws IOException {
        Preconditions.checkNotNull((Object)restClient);
        return restClient.sendRequest(targetAddress, port, messageHeaders, messageParameters, request);
    }
}

