/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Uid;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHits;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSearchResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SourceLookup;

public final class InnerHitsPhase
implements FetchSubPhase {
    private final FetchPhase fetchPhase;

    public InnerHitsPhase(FetchPhase fetchPhase) {
        this.fetchPhase = fetchPhase;
    }

    @Override
    public FetchSubPhaseProcessor getProcessor(final FetchContext searchContext) {
        if (searchContext.innerHits() == null) {
            return null;
        }
        final Map<String, InnerHitsContext.InnerHitSubContext> innerHits = searchContext.innerHits().getInnerHits();
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                SearchHit hit = hitContext.hit();
                SourceLookup rootLookup = searchContext.getRootSourceLookup(hitContext);
                InnerHitsPhase.this.hitExecute(innerHits, hit, rootLookup);
            }
        };
    }

    private void hitExecute(Map<String, InnerHitsContext.InnerHitSubContext> innerHits, SearchHit hit, SourceLookup rootLookup) throws IOException {
        for (Map.Entry<String, InnerHitsContext.InnerHitSubContext> entry : innerHits.entrySet()) {
            InnerHitsContext.InnerHitSubContext innerHitsContext = entry.getValue();
            TopDocsAndMaxScore topDoc = innerHitsContext.topDocs(hit);
            Map<String, SearchHits> results = hit.getInnerHits();
            if (results == null) {
                results = new HashMap<String, SearchHits>();
                hit.setInnerHits(results);
            }
            innerHitsContext.queryResult().topDocs(topDoc, innerHitsContext.sort() == null ? null : innerHitsContext.sort().formats);
            int[] docIdsToLoad = new int[topDoc.topDocs.scoreDocs.length];
            for (int j = 0; j < topDoc.topDocs.scoreDocs.length; ++j) {
                docIdsToLoad[j] = topDoc.topDocs.scoreDocs[j].doc;
            }
            innerHitsContext.docIdsToLoad(docIdsToLoad, 0, docIdsToLoad.length);
            innerHitsContext.setRootId(new Uid(hit.getType(), hit.getId()));
            innerHitsContext.setRootLookup(rootLookup);
            this.fetchPhase.execute(innerHitsContext);
            FetchSearchResult fetchResult = innerHitsContext.fetchResult();
            SearchHit[] internalHits = fetchResult.fetchResult().hits().getHits();
            for (int j = 0; j < internalHits.length; ++j) {
                ScoreDoc scoreDoc = topDoc.topDocs.scoreDocs[j];
                SearchHit searchHitFields = internalHits[j];
                searchHitFields.score(scoreDoc.score);
                if (!(scoreDoc instanceof FieldDoc)) continue;
                FieldDoc fieldDoc = (FieldDoc)scoreDoc;
                searchHitFields.sortValues(fieldDoc.fields, innerHitsContext.sort().formats);
            }
            results.put(entry.getKey(), fetchResult.hits());
        }
    }
}

