/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.SearchHit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhase;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.FetchSubPhaseProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SourceLookup;

public final class FetchSourcePhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext fetchContext) {
        final FetchSourceContext fetchSourceContext = fetchContext.fetchSourceContext();
        if (fetchSourceContext == null || !fetchSourceContext.fetchSource()) {
            return null;
        }
        final String index = fetchContext.getIndexName();
        assert (fetchSourceContext.fetchSource());
        return new FetchSubPhaseProcessor(){

            @Override
            public void setNextReader(LeafReaderContext readerContext) {
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) {
                FetchSourcePhase.this.hitExecute(index, fetchSourceContext, hitContext);
            }
        };
    }

    private void hitExecute(String index, FetchSourceContext fetchSourceContext, FetchSubPhase.HitContext hitContext) {
        boolean nestedHit = hitContext.hit().getNestedIdentity() != null;
        SourceLookup source = hitContext.sourceLookup();
        if (source.source() == null && source.internalSourceRef() == null) {
            if (FetchSourcePhase.containsFilters(fetchSourceContext)) {
                throw new IllegalArgumentException("unable to fetch fields from _source field: _source is disabled in the mappings for index [" + index + "]");
            }
            return;
        }
        if (!nestedHit && !FetchSourcePhase.containsFilters(fetchSourceContext)) {
            hitContext.hit().sourceRef(source.internalSourceRef());
            return;
        }
        Map<String, Object> value = source.filter(fetchSourceContext);
        if (nestedHit) {
            value = this.getNestedSource(value, hitContext);
        }
        try {
            int initialCapacity = nestedHit ? 1024 : Math.min(1024, source.internalSourceRef().length());
            BytesStreamOutput streamOutput = new BytesStreamOutput(initialCapacity);
            XContentBuilder builder = new XContentBuilder(source.sourceContentType().xContent(), streamOutput);
            if (value != null) {
                builder.value(value);
            } else {
                builder.startObject();
                builder.endObject();
            }
            hitContext.hit().sourceRef(BytesReference.bytes(builder));
        }
        catch (IOException e) {
            throw new ElasticsearchException("Error filtering source", (Throwable)e, new Object[0]);
        }
    }

    private static boolean containsFilters(FetchSourceContext context) {
        return context.includes().length != 0 || context.excludes().length != 0;
    }

    private Map<String, Object> getNestedSource(Map<String, Object> sourceAsMap, FetchSubPhase.HitContext hitContext) {
        for (SearchHit.NestedIdentity o = hitContext.hit().getNestedIdentity(); o != null; o = o.getChild()) {
            if ((sourceAsMap = (Map)sourceAsMap.get(o.getField().string())) != null) continue;
            return null;
        }
        return sourceAsMap;
    }
}

