/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.TriFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.Script;

public class MultiValuesSourceFieldConfig
implements Writeable,
ToXContentObject {
    private final String fieldName;
    private final Object missing;
    private final Script script;
    private final ZoneId timeZone;
    private final QueryBuilder filter;
    private static final String NAME = "field_config";
    public static final ParseField FILTER = new ParseField("filter", new String[0]);
    public static final TriFunction<Boolean, Boolean, Boolean, ObjectParser<Builder, Void>> PARSER = (scriptable, timezoneAware, filtered) -> {
        ObjectParser<Builder, Void> parser = new ObjectParser<Builder, Void>(NAME, Builder::new);
        parser.declareString(Builder::setFieldName, ParseField.CommonFields.FIELD);
        parser.declareField(Builder::setMissing, XContentParser::objectText, ParseField.CommonFields.MISSING, ObjectParser.ValueType.VALUE);
        if (scriptable.booleanValue()) {
            parser.declareField(Builder::setScript, (p, context) -> Script.parse(p), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        }
        if (timezoneAware.booleanValue()) {
            parser.declareField(Builder::setTimeZone, p -> {
                if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                    return ZoneId.of(p.text());
                }
                return ZoneOffset.ofHours(p.intValue());
            }, ParseField.CommonFields.TIME_ZONE, ObjectParser.ValueType.LONG);
        }
        if (filtered.booleanValue()) {
            parser.declareField(Builder::setFilter, (p, context) -> AbstractQueryBuilder.parseInnerQueryBuilder(p), FILTER, ObjectParser.ValueType.OBJECT);
        }
        return parser;
    };

    protected MultiValuesSourceFieldConfig(String fieldName, Object missing, Script script, ZoneId timeZone, QueryBuilder filter) {
        this.fieldName = fieldName;
        this.missing = missing;
        this.script = script;
        this.timeZone = timeZone;
        this.filter = filter;
    }

    public MultiValuesSourceFieldConfig(StreamInput in) throws IOException {
        this.fieldName = in.getVersion().onOrAfter(Version.V_7_6_0) ? in.readOptionalString() : in.readString();
        this.missing = in.readGenericValue();
        this.script = in.readOptionalWriteable(Script::new);
        this.timeZone = in.getVersion().before(Version.V_7_0_0) ? DateUtils.dateTimeZoneToZoneId(in.readOptionalTimeZone()) : in.readOptionalZoneId();
        this.filter = in.getVersion().onOrAfter(Version.V_7_8_0) ? in.readOptionalNamedWriteable(QueryBuilder.class) : null;
    }

    public Object getMissing() {
        return this.missing;
    }

    public Script getScript() {
        return this.script;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public QueryBuilder getFilter() {
        return this.filter;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_6_0)) {
            out.writeOptionalString(this.fieldName);
        } else {
            out.writeString(this.fieldName);
        }
        out.writeGenericValue(this.missing);
        out.writeOptionalWriteable(this.script);
        if (out.getVersion().before(Version.V_7_0_0)) {
            out.writeOptionalTimeZone(DateUtils.zoneIdToDateTimeZone(this.timeZone));
        } else {
            out.writeOptionalZoneId(this.timeZone);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeOptionalNamedWriteable(this.filter);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.missing != null) {
            builder.field(ParseField.CommonFields.MISSING.getPreferredName(), this.missing);
        }
        if (this.script != null) {
            builder.field(Script.SCRIPT_PARSE_FIELD.getPreferredName(), this.script);
        }
        if (this.fieldName != null) {
            builder.field(ParseField.CommonFields.FIELD.getPreferredName(), this.fieldName);
        }
        if (this.timeZone != null) {
            builder.field(ParseField.CommonFields.TIME_ZONE.getPreferredName(), this.timeZone.getId());
        }
        if (this.filter != null) {
            builder.field(FILTER.getPreferredName());
            this.filter.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiValuesSourceFieldConfig that = (MultiValuesSourceFieldConfig)o;
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.missing, that.missing) && Objects.equals(this.script, that.script) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.missing, this.script, this.timeZone, this.filter);
    }

    public String toString() {
        return Strings.toString(this);
    }

    public static class Builder {
        private String fieldName;
        private Object missing = null;
        private Script script = null;
        private ZoneId timeZone = null;
        private QueryBuilder filter = null;

        public String getFieldName() {
            return this.fieldName;
        }

        public Builder setFieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Object getMissing() {
            return this.missing;
        }

        public Builder setMissing(Object missing) {
            this.missing = missing;
            return this;
        }

        public Script getScript() {
            return this.script;
        }

        public Builder setScript(Script script) {
            this.script = script;
            return this;
        }

        public ZoneId getTimeZone() {
            return this.timeZone;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public Builder setFilter(QueryBuilder filter) {
            this.filter = filter;
            return this;
        }

        public MultiValuesSourceFieldConfig build() {
            if (Strings.isNullOrEmpty(this.fieldName) && this.script == null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be null.  Please specify one or the other.");
            }
            if (!Strings.isNullOrEmpty(this.fieldName) && this.script != null) {
                throw new IllegalArgumentException("[" + ParseField.CommonFields.FIELD.getPreferredName() + "] and [" + Script.SCRIPT_PARSE_FIELD.getPreferredName() + "] cannot both be configured.  Please specify one or the other.");
            }
            return new MultiValuesSourceFieldConfig(this.fieldName, this.missing, this.script, this.timeZone, this.filter);
        }
    }
}

