/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.AbstractTDigestPercentilesAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.InternalTDigestPercentiles;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

class TDigestPercentilesAggregator
extends AbstractTDigestPercentilesAggregator {
    TDigestPercentilesAggregator(String name, ValuesSource valuesSource, SearchContext context, Aggregator parent, double[] percents, double compression, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, valuesSource, context, parent, percents, compression, keyed, formatter, metadata);
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalTDigestPercentiles(this.name, this.keys, state, this.keyed, this.formatter, this.metadata());
    }

    @Override
    public double metric(String name, long bucketOrd) {
        TDigestState state = this.getState(bucketOrd);
        if (state == null) {
            return Double.NaN;
        }
        return state.quantile(Double.parseDouble(name) / 100.0);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalTDigestPercentiles(this.name, this.keys, new TDigestState(this.compression), this.keyed, this.formatter, this.metadata());
    }
}

