/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregatorFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.metrics.GeoBoundsAggregatorSupplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;

public class GeoBoundsAggregationBuilder
extends ValuesSourceAggregationBuilder<GeoBoundsAggregationBuilder> {
    public static final String NAME = "geo_bounds";
    public static final ValuesSourceRegistry.RegistryKey<GeoBoundsAggregatorSupplier> REGISTRY_KEY = new ValuesSourceRegistry.RegistryKey<GeoBoundsAggregatorSupplier>("geo_bounds", GeoBoundsAggregatorSupplier.class);
    public static final ObjectParser<GeoBoundsAggregationBuilder, String> PARSER = ObjectParser.fromBuilder("geo_bounds", GeoBoundsAggregationBuilder::new);
    private boolean wrapLongitude = true;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        GeoBoundsAggregatorFactory.registerAggregators(builder);
    }

    public GeoBoundsAggregationBuilder(String name) {
        super(name);
    }

    protected GeoBoundsAggregationBuilder(GeoBoundsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        super(clone, factoriesBuilder, metadata);
        this.wrapLongitude = clone.wrapLongitude;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metadata) {
        return new GeoBoundsAggregationBuilder(this, factoriesBuilder, metadata);
    }

    public GeoBoundsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.wrapLongitude = in.readBoolean();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.wrapLongitude);
    }

    @Override
    protected ValuesSourceType defaultValueSourceType() {
        return CoreValuesSourceType.GEOPOINT;
    }

    public GeoBoundsAggregationBuilder wrapLongitude(boolean wrapLongitude) {
        this.wrapLongitude = wrapLongitude;
        return this;
    }

    public boolean wrapLongitude() {
        return this.wrapLongitude;
    }

    @Override
    public AggregationBuilder.BucketCardinality bucketCardinality() {
        return AggregationBuilder.BucketCardinality.NONE;
    }

    @Override
    protected GeoBoundsAggregatorFactory innerBuild(QueryShardContext queryShardContext, ValuesSourceConfig config, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return new GeoBoundsAggregatorFactory(this.name, config, this.wrapLongitude, queryShardContext, parent, subFactoriesBuilder, this.metadata);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(GeoBoundsAggregator.WRAP_LONGITUDE_FIELD.getPreferredName(), this.wrapLongitude);
        return builder;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.wrapLongitude);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        GeoBoundsAggregationBuilder other = (GeoBoundsAggregationBuilder)obj;
        return Objects.equals(this.wrapLongitude, other.wrapLongitude);
    }

    @Override
    public String getType() {
        return NAME;
    }

    @Override
    protected ValuesSourceRegistry.RegistryKey<?> getRegistryKey() {
        return REGISTRY_KEY;
    }

    static {
        ValuesSourceAggregationBuilder.declareFields(PARSER, false, false, false);
        PARSER.declareBoolean(GeoBoundsAggregationBuilder::wrapLongitude, GeoBoundsAggregator.WRAP_LONGITUDE_FIELD);
    }
}

