/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.PriorityQueue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalOrder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.KeyComparable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.IteratorAndCurrent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;

public abstract class InternalTerms<A extends InternalTerms<A, B>, B extends Bucket<B>>
extends InternalMultiBucketAggregation<A, B>
implements Terms {
    protected static final ParseField DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME = new ParseField("doc_count_error_upper_bound", new String[0]);
    protected static final ParseField SUM_OF_OTHER_DOC_COUNTS = new ParseField("sum_other_doc_count", new String[0]);
    protected final BucketOrder reduceOrder;
    protected final BucketOrder order;
    protected final int requiredSize;
    protected final long minDocCount;

    protected InternalTerms(String name, BucketOrder reduceOrder, BucketOrder order, int requiredSize, long minDocCount, Map<String, Object> metadata) {
        super(name, metadata);
        this.reduceOrder = reduceOrder;
        this.order = order;
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
    }

    protected InternalTerms(StreamInput in) throws IOException {
        super(in);
        this.reduceOrder = InternalOrder.Streams.readOrder(in);
        this.order = in.getVersion().onOrAfter(Version.V_7_10_0) ? InternalOrder.Streams.readOrder(in) : this.reduceOrder;
        this.requiredSize = InternalTerms.readSize(in);
        this.minDocCount = in.readVLong();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.reduceOrder.writeTo(out);
        }
        this.order.writeTo(out);
        InternalTerms.writeSize(this.requiredSize, out);
        out.writeVLong(this.minDocCount);
        this.writeTermTypeInfoTo(out);
    }

    protected abstract void writeTermTypeInfoTo(StreamOutput var1) throws IOException;

    @Override
    public abstract List<B> getBuckets();

    public abstract B getBucketByKey(String var1);

    private BucketOrder getReduceOrder(List<InternalAggregation> aggregations) {
        BucketOrder thisReduceOrder = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms.getBuckets().size() == 0) continue;
            if (thisReduceOrder == null) {
                thisReduceOrder = terms.reduceOrder;
                continue;
            }
            if (thisReduceOrder.equals(terms.reduceOrder)) continue;
            return this.order;
        }
        return thisReduceOrder != null ? thisReduceOrder : this.order;
    }

    private long getDocCountError(InternalTerms<?, ?> terms) {
        int size = terms.getBuckets().size();
        if (size == 0 || size < terms.getShardSize() || InternalOrder.isKeyOrder(terms.order)) {
            return 0L;
        }
        if (InternalOrder.isCountDesc(terms.order)) {
            if (terms.getDocCountError() > 0L) {
                return terms.getDocCountError();
            }
            return terms.getBuckets().stream().mapToLong(Bucket::getDocCount).min().getAsLong();
        }
        return -1L;
    }

    private List<B> reduceMergeSort(List<InternalAggregation> aggregations, BucketOrder thisReduceOrder, InternalAggregation.ReduceContext reduceContext) {
        assert (InternalOrder.isKeyOrder(thisReduceOrder));
        final Comparator<MultiBucketsAggregation.Bucket> cmp = thisReduceOrder.comparator();
        PriorityQueue pq = new PriorityQueue<IteratorAndCurrent<B>>(aggregations.size()){

            @Override
            protected boolean lessThan(IteratorAndCurrent<B> a, IteratorAndCurrent<B> b) {
                return cmp.compare(a.current(), b.current()) < 0;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            assert (this.reduceOrder.equals(this.reduceOrder));
            pq.add(new IteratorAndCurrent<B>(terms.getBuckets().iterator()));
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> reducedBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
        Bucket lastBucket = null;
        while (pq.size() > 0) {
            IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
            assert (lastBucket == null || cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) >= 0);
            if (lastBucket != null && cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) != 0) {
                InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
                reducedBuckets.add(reduced);
                currentBuckets.clear();
            }
            lastBucket = (Bucket)top.current();
            currentBuckets.add((Bucket)top.current());
            if (top.hasNext()) {
                top.next();
                assert (cmp.compare((MultiBucketsAggregation.Bucket)top.current(), lastBucket) > 0) : "shards must return data sorted by key";
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (!currentBuckets.isEmpty()) {
            InternalMultiBucketAggregation.InternalBucket reduced = this.reduceBucket(currentBuckets, reduceContext);
            reducedBuckets.add(reduced);
        }
        return reducedBuckets;
    }

    private List<B> reduceLegacy(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        HashMap<Object, ArrayList<Bucket>> bucketMap = new HashMap<Object, ArrayList<Bucket>>();
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (terms.getBuckets().isEmpty()) continue;
            for (Bucket bucket : terms.getBuckets()) {
                ArrayList<Bucket> bucketList = (ArrayList<Bucket>)bucketMap.get(bucket.getKey());
                if (bucketList == null) {
                    bucketList = new ArrayList<Bucket>();
                    bucketMap.put(bucket.getKey(), bucketList);
                }
                bucketList.add(bucket);
            }
        }
        ArrayList<InternalMultiBucketAggregation.InternalBucket> reducedBuckets = new ArrayList<InternalMultiBucketAggregation.InternalBucket>();
        for (List sameTermBuckets : bucketMap.values()) {
            InternalMultiBucketAggregation.InternalBucket b = this.reduceBucket(sameTermBuckets, reduceContext);
            reducedBuckets.add(b);
        }
        return reducedBuckets;
    }

    @Override
    public InternalAggregation reduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        Bucket[] list;
        int size;
        List<B> reducedBuckets;
        long sumDocCountError = 0L;
        long otherDocCount = 0L;
        Object referenceTerms = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalTerms terms = (InternalTerms)aggregation;
            if (referenceTerms == null && !aggregation.getClass().equals(UnmappedTerms.class)) {
                referenceTerms = terms;
            }
            if (referenceTerms != null && !referenceTerms.getClass().equals(terms.getClass()) && !terms.getClass().equals(UnmappedTerms.class)) {
                throw new AggregationExecutionException("Merging/Reducing the aggregations failed when computing the aggregation [" + ((InternalAggregation)referenceTerms).getName() + "] because the field you gave in the aggregation query existed as two different types in two different indices");
            }
            otherDocCount += terms.getSumOfOtherDocCounts();
            long thisAggDocCountError = this.getDocCountError(terms);
            if (sumDocCountError != -1L) {
                sumDocCountError = thisAggDocCountError == -1L ? -1L : (sumDocCountError += thisAggDocCountError);
            }
            this.setDocCountError(thisAggDocCountError);
            for (Bucket bucket : terms.getBuckets()) {
                bucket.docCountError -= thisAggDocCountError;
            }
        }
        BucketOrder thisReduceOrder = this.getReduceOrder(aggregations);
        if (InternalOrder.isKeyOrder(thisReduceOrder)) {
            thisReduceOrder = InternalOrder.key(InternalOrder.isKeyAsc(thisReduceOrder));
            reducedBuckets = this.reduceMergeSort(aggregations, thisReduceOrder, reduceContext);
        } else {
            reducedBuckets = this.reduceLegacy(aggregations, reduceContext);
        }
        if (reduceContext.isFinalReduce()) {
            size = Math.min(this.requiredSize, reducedBuckets.size());
            BucketPriorityQueue<MultiBucketsAggregation.Bucket> ordered = new BucketPriorityQueue<MultiBucketsAggregation.Bucket>(size, this.order.comparator());
            for (Bucket bucket : reducedBuckets) {
                bucket.docCountError = sumDocCountError == -1L ? -1L : (bucket.docCountError += sumDocCountError);
                if (bucket.docCount >= this.minDocCount) {
                    Bucket removed = ordered.insertWithOverflow(bucket);
                    if (removed != null) {
                        otherDocCount += removed.getDocCount();
                        reduceContext.consumeBucketsAndMaybeBreak(-InternalTerms.countInnerBucket(removed));
                        continue;
                    }
                    reduceContext.consumeBucketsAndMaybeBreak(1);
                    continue;
                }
                reduceContext.consumeBucketsAndMaybeBreak(-InternalTerms.countInnerBucket(bucket));
            }
            list = this.createBucketsArray(ordered.size());
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (Bucket)ordered.pop();
            }
        } else {
            size = InternalOrder.isKeyOrder(this.order) && this.minDocCount == 0L ? Math.min(this.requiredSize, reducedBuckets.size()) : reducedBuckets.size();
            list = this.createBucketsArray(size);
            for (int i = 0; i < size; ++i) {
                reduceContext.consumeBucketsAndMaybeBreak(1);
                list[i] = (Bucket)reducedBuckets.get(i);
                if (sumDocCountError == -1L) {
                    list[i].docCountError = -1L;
                    continue;
                }
                list[i].docCountError += sumDocCountError;
            }
        }
        long docCountError = sumDocCountError == -1L ? -1L : (aggregations.size() == 1 ? 0L : sumDocCountError);
        return this.create(this.name, Arrays.asList(list), reduceContext.isFinalReduce() ? this.order : thisReduceOrder, docCountError, otherDocCount);
    }

    @Override
    protected B reduceBucket(List<B> buckets, InternalAggregation.ReduceContext context) {
        assert (buckets.size() > 0);
        long docCount = 0L;
        long docCountError = 0L;
        ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
        for (Bucket bucket : buckets) {
            docCount += bucket.docCount;
            if (docCountError != -1L) {
                docCountError = bucket.docCountError == -1L ? -1L : (docCountError += bucket.docCountError);
            }
            aggregationsList.add(bucket.aggregations);
        }
        InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
        return (B)this.createBucket(docCount, aggs, docCountError, (Bucket)buckets.get(0));
    }

    protected abstract void setDocCountError(long var1);

    protected abstract int getShardSize();

    protected abstract A create(String var1, List<B> var2, BucketOrder var3, long var4, long var6);

    protected abstract B[] createBucketsArray(int var1);

    abstract B createBucket(long var1, InternalAggregations var3, long var4, B var6);

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalTerms that = (InternalTerms)obj;
        return Objects.equals(this.minDocCount, that.minDocCount) && Objects.equals(this.reduceOrder, that.reduceOrder) && Objects.equals(this.order, that.order) && Objects.equals(this.requiredSize, that.requiredSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minDocCount, this.reduceOrder, this.order, this.requiredSize);
    }

    protected static XContentBuilder doXContentCommon(XContentBuilder builder, ToXContent.Params params, long docCountError, long otherDocCount, List<? extends Bucket> buckets) throws IOException {
        builder.field(DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), docCountError);
        builder.field(SUM_OF_OTHER_DOC_COUNTS.getPreferredName(), otherDocCount);
        builder.startArray(Aggregation.CommonFields.BUCKETS.getPreferredName());
        for (Bucket bucket : buckets) {
            bucket.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static abstract class Bucket<B extends Bucket<B>>
    extends InternalMultiBucketAggregation.InternalBucket
    implements Terms.Bucket,
    KeyComparable<B> {
        long bucketOrd;
        protected long docCount;
        protected long docCountError;
        protected InternalAggregations aggregations;
        protected final boolean showDocCountError;
        protected final DocValueFormat format;

        protected Bucket(long docCount, InternalAggregations aggregations, boolean showDocCountError, long docCountError, DocValueFormat formatter) {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.docCountError = docCountError;
        }

        protected Bucket(StreamInput in, DocValueFormat formatter, boolean showDocCountError) throws IOException {
            this.showDocCountError = showDocCountError;
            this.format = formatter;
            this.docCount = in.readVLong();
            this.docCountError = -1L;
            if (showDocCountError) {
                this.docCountError = in.readLong();
            }
            this.aggregations = InternalAggregations.readFrom(in);
        }

        @Override
        public final void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.getDocCount());
            if (this.showDocCountError) {
                out.writeLong(this.docCountError);
            }
            this.aggregations.writeTo(out);
            this.writeTermTo(out);
        }

        protected abstract void writeTermTo(StreamOutput var1) throws IOException;

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public long getDocCountError() {
            if (!this.showDocCountError) {
                throw new IllegalStateException("show_terms_doc_count_error is false");
            }
            return this.docCountError;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.keyToXContent(builder);
            builder.field(Aggregation.CommonFields.DOC_COUNT.getPreferredName(), this.getDocCount());
            if (this.showDocCountError) {
                builder.field(DOC_COUNT_ERROR_UPPER_BOUND_FIELD_NAME.getPreferredName(), this.getDocCountError());
            }
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        protected abstract XContentBuilder keyToXContent(XContentBuilder var1) throws IOException;

        public boolean equals(Object obj) {
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Bucket that = (Bucket)obj;
            return Objects.equals(this.docCount, that.docCount) && Objects.equals(this.docCountError, that.docCountError) && Objects.equals(this.aggregations, that.aggregations);
        }

        public int hashCode() {
            return Objects.hash(this.getClass(), this.docCount, this.docCountError, this.aggregations);
        }

        @FunctionalInterface
        public static interface Reader<B extends Bucket<B>> {
            public B read(StreamInput var1, DocValueFormat var2, boolean var3) throws IOException;
        }
    }
}

