/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.Queries;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.BucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.InternalAggregations;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.global.GlobalAggregator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.InternalProfileCollector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.query.QueryPhaseExecutionException;

public class AggregationPhase {
    @Inject
    public AggregationPhase() {
    }

    public void preProcess(SearchContext context) {
        if (context.aggregations() != null) {
            ArrayList<Aggregator> collectors = new ArrayList<Aggregator>();
            try {
                AggregatorFactories factories = context.aggregations().factories();
                Aggregator[] aggregators = factories.createTopLevelAggregators(context);
                for (int i = 0; i < aggregators.length; ++i) {
                    if (aggregators[i] instanceof GlobalAggregator) continue;
                    collectors.add(aggregators[i]);
                }
                context.aggregations().aggregators(aggregators);
                if (!collectors.isEmpty()) {
                    Collector collector = MultiBucketCollector.wrap(collectors);
                    collector.preCollection();
                    if (context.getProfilers() != null) {
                        collector = new InternalProfileCollector(collector, "aggregation", Collections.emptyList());
                    }
                    context.queryCollectors().put(AggregationPhase.class, collector);
                }
            }
            catch (IOException e) {
                throw new AggregationInitializationException("Could not initialize aggregators", e);
            }
        }
    }

    public void execute(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().hasAggs()) {
            return;
        }
        Aggregator[] aggregators = context.aggregations().aggregators();
        ArrayList<Aggregator> globals = new ArrayList<Aggregator>();
        for (int i = 0; i < aggregators.length; ++i) {
            if (!(aggregators[i] instanceof GlobalAggregator)) continue;
            globals.add(aggregators[i]);
        }
        if (!globals.isEmpty()) {
            BucketCollector globalsCollector = MultiBucketCollector.wrap(globals);
            Query query = context.buildFilteredQuery(Queries.newMatchAllQuery());
            try {
                Collector collector;
                if (context.getProfilers() == null) {
                    collector = globalsCollector;
                } else {
                    InternalProfileCollector profileCollector = new InternalProfileCollector(globalsCollector, "aggregation_global", Collections.emptyList());
                    collector = profileCollector;
                    context.getProfilers().addQueryProfiler().setCollector(profileCollector);
                }
                globalsCollector.preCollection();
                context.searcher().search(query, collector);
            }
            catch (Exception e) {
                throw new QueryPhaseExecutionException(context.shardTarget(), "Failed to execute global aggregators", e);
            }
        }
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>(aggregators.length);
        context.aggregations().resetBucketMultiConsumer();
        for (Aggregator aggregator : context.aggregations().aggregators()) {
            try {
                aggregator.postCollection();
                aggregations.add(aggregator.buildTopLevel());
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
            }
        }
        context.queryResult().aggregations(new InternalAggregations(aggregations, context.request().source().aggregations()::buildPipelineTree));
        context.aggregations(null);
        context.queryCollectors().remove(AggregationPhase.class);
    }
}

