/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.mustache;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch7.shaded.com.fasterxml.jackson.core.io.JsonStringEncoder;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.Code;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.DefaultMustacheFactory;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.DefaultMustacheVisitor;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.Mustache;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.MustacheException;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.MustacheVisitor;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.TemplateContext;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.codes.DefaultMustache;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.codes.IterableCode;
import org.apache.flink.elasticsearch7.shaded.com.github.mustachejava.codes.WriteCode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.mustache.CustomReflectionObjectHandler;

public class CustomMustacheFactory
extends DefaultMustacheFactory {
    static final String JSON_MIME_TYPE_WITH_CHARSET = "application/json; charset=UTF-8";
    static final String JSON_MIME_TYPE = "application/json";
    static final String PLAIN_TEXT_MIME_TYPE = "text/plain";
    static final String X_WWW_FORM_URLENCODED_MIME_TYPE = "application/x-www-form-urlencoded";
    private static final String DEFAULT_MIME_TYPE = "application/json";
    private static final Map<String, Supplier<Encoder>> ENCODERS;
    private final Encoder encoder;

    public CustomMustacheFactory(String mimeType) {
        this.setObjectHandler(new CustomReflectionObjectHandler());
        this.encoder = CustomMustacheFactory.createEncoder(mimeType);
    }

    public CustomMustacheFactory() {
        this("application/json");
    }

    @Override
    public void encode(String value, Writer writer) {
        try {
            this.encoder.encode(value, writer);
        }
        catch (IOException e) {
            throw new MustacheException("Unable to encode value", e);
        }
    }

    static Encoder createEncoder(String mimeType) {
        Supplier<Encoder> supplier = ENCODERS.get(mimeType);
        if (supplier == null) {
            throw new IllegalArgumentException("No encoder found for MIME type [" + mimeType + "]");
        }
        return supplier.get();
    }

    @Override
    public MustacheVisitor createMustacheVisitor() {
        return new CustomMustacheVisitor(this);
    }

    static {
        HashMap<String, Supplier<Encoder>> encoders = new HashMap<String, Supplier<Encoder>>();
        encoders.put(JSON_MIME_TYPE_WITH_CHARSET, JsonEscapeEncoder::new);
        encoders.put("application/json", JsonEscapeEncoder::new);
        encoders.put(PLAIN_TEXT_MIME_TYPE, DefaultEncoder::new);
        encoders.put(X_WWW_FORM_URLENCODED_MIME_TYPE, UrlEncoder::new);
        ENCODERS = Collections.unmodifiableMap(encoders);
    }

    @FunctionalInterface
    static interface Encoder {
        public void encode(String var1, Writer var2) throws IOException;
    }

    class CustomMustacheVisitor
    extends DefaultMustacheVisitor {
        CustomMustacheVisitor(DefaultMustacheFactory df) {
            super(df);
        }

        @Override
        public void iterable(TemplateContext templateContext, String variable, Mustache mustache) {
            if (ToJsonCode.match(variable)) {
                this.list.add(new ToJsonCode(templateContext, this.df, mustache, variable));
            } else if (JoinerCode.match(variable)) {
                this.list.add(new JoinerCode(templateContext, this.df, mustache));
            } else if (CustomJoinerCode.match(variable)) {
                this.list.add(new CustomJoinerCode(templateContext, this.df, mustache, variable));
            } else if (UrlEncoderCode.match(variable)) {
                this.list.add(new UrlEncoderCode(templateContext, this.df, mustache, variable));
            } else {
                this.list.add(new IterableCode(templateContext, this.df, mustache, variable));
            }
        }
    }

    static class UrlEncoder
    implements Encoder {
        UrlEncoder() {
        }

        @Override
        public void encode(String s, Writer writer) throws IOException {
            writer.write(URLEncoder.encode(s, StandardCharsets.UTF_8.name()));
        }
    }

    static class JsonEscapeEncoder
    implements Encoder {
        JsonEscapeEncoder() {
        }

        @Override
        public void encode(String s, Writer writer) throws IOException {
            writer.write(JsonStringEncoder.getInstance().quoteAsString(s));
        }
    }

    static class DefaultEncoder
    implements Encoder {
        DefaultEncoder() {
        }

        @Override
        public void encode(String s, Writer writer) throws IOException {
            writer.write(s);
        }
    }

    static class UrlEncoderCode
    extends DefaultMustache {
        private static final String CODE = "url";
        private final Encoder encoder = new UrlEncoder();

        UrlEncoderCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache.getCodes(), variable);
        }

        @Override
        public Writer run(Writer writer, List<Object> scopes) {
            if (this.getCodes() != null) {
                for (Code code : this.getCodes()) {
                    try (StringWriter capture = new StringWriter();){
                        code.execute(capture, scopes);
                        String s = capture.toString();
                        if (s == null) continue;
                        this.encoder.encode(s, writer);
                    }
                    catch (IOException e) {
                        throw new MustacheException("Exception while parsing mustache function at line " + this.tc.line(), e);
                    }
                }
            }
            return writer;
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    static class CustomJoinerCode
    extends JoinerCode {
        private static final Pattern PATTERN = Pattern.compile("^(?:join delimiter='(.*)')$");

        CustomJoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache, CustomJoinerCode.extractDelimiter(variable));
        }

        private static String extractDelimiter(String variable) {
            Matcher matcher = PATTERN.matcher(variable);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new MustacheException("Failed to extract delimiter for join function");
        }

        static boolean match(String variable) {
            return PATTERN.matcher(variable).matches();
        }
    }

    static class JoinerCode
    extends CustomCode {
        protected static final String CODE = "join";
        private static final String DEFAULT_DELIMITER = ",";
        private final String delimiter;

        JoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String delimiter) {
            super(tc, df, mustache, CODE);
            this.delimiter = delimiter;
        }

        JoinerCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache) {
            this(tc, df, mustache, DEFAULT_DELIMITER);
        }

        @Override
        protected Function<String, String> createFunction(Object resolved) {
            return s -> {
                if (s == null) {
                    return null;
                }
                if (resolved instanceof Iterable) {
                    StringJoiner joiner = new StringJoiner(this.delimiter);
                    for (Object o : (Iterable)resolved) {
                        joiner.add(this.oh.stringify(o));
                    }
                    return joiner.toString();
                }
                return s;
            };
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    static class ToJsonCode
    extends CustomCode {
        private static final String CODE = "toJson";

        ToJsonCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String variable) {
            super(tc, df, mustache, CODE);
            if (!CODE.equalsIgnoreCase(variable)) {
                throw new MustacheException("Mismatch function code [toJson] cannot be applied to [" + variable + "]");
            }
        }

        @Override
        protected Function<String, String> createFunction(Object resolved) {
            return s -> {
                if (resolved == null) {
                    return null;
                }
                try (XContentBuilder builder = XContentBuilder.builder(XContentType.JSON.xContent());){
                    if (resolved instanceof Iterable) {
                        builder.startArray();
                        for (Object o : (Iterable)resolved) {
                            builder.value(o);
                        }
                        builder.endArray();
                    } else {
                        if (!(resolved instanceof Map)) {
                            String string = this.oh.stringify(resolved);
                            return string;
                        }
                        builder.map((Map)resolved);
                    }
                    String string = Strings.toString(builder);
                    return string;
                }
                catch (IOException e) {
                    throw new MustacheException("Failed to convert object to JSON", e);
                }
            };
        }

        static boolean match(String variable) {
            return CODE.equalsIgnoreCase(variable);
        }
    }

    static abstract class CustomCode
    extends IterableCode {
        private final String code;

        CustomCode(TemplateContext tc, DefaultMustacheFactory df, Mustache mustache, String code) {
            super(tc, df, mustache, CustomCode.extractVariableName(code, mustache, tc));
            this.code = Objects.requireNonNull(code);
        }

        @Override
        public Writer execute(Writer writer, List<Object> scopes) {
            Object resolved = this.get(scopes);
            writer = this.handle(writer, this.createFunction(resolved), scopes);
            this.appendText(writer);
            return writer;
        }

        @Override
        protected void tag(Writer writer, String tag) throws IOException {
            writer.write(this.tc.startChars());
            writer.write(tag);
            writer.write(this.code);
            writer.write(this.tc.endChars());
        }

        protected abstract Function<String, String> createFunction(Object var1);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected static String extractVariableName(String fn, Mustache mustache, TemplateContext tc) {
            Code[] codes = mustache.getCodes();
            if (codes == null) throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
            if (codes.length != 1) {
                throw new MustacheException("Mustache function [" + fn + "] must contain one and only one identifier");
            }
            try (StringWriter capture = new StringWriter();){
                if (codes[0] instanceof WriteCode) {
                    codes[0].execute(capture, Collections.emptyList());
                    String string = capture.toString();
                    return string;
                }
                codes[0].identity(capture);
                String string = capture.toString();
                return string;
            }
            catch (IOException e) {
                throw new MustacheException("Exception while parsing mustache function [" + fn + "] at line " + tc.line(), e);
            }
        }
    }
}

