/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestPutComposableIndexTemplateAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/_index_template/{name}"), new RestHandler.Route(RestRequest.Method.PUT, "/_index_template/{name}"));
    }

    @Override
    public String getName() {
        return "put_composable_index_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutComposableIndexTemplateAction.Request putRequest = new PutComposableIndexTemplateAction.Request(request.param("name"));
        putRequest.masterNodeTimeout(request.paramAsTime("master_timeout", putRequest.masterNodeTimeout()));
        putRequest.create(request.paramAsBoolean("create", false));
        putRequest.cause(request.param("cause", "api"));
        putRequest.indexTemplate(ComposableIndexTemplate.parse(request.contentParser()));
        return channel -> client.execute(PutComposableIndexTemplateAction.INSTANCE, putRequest, new RestToXContentListener((RestChannel)channel));
    }
}

