/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.main.MainAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.main.MainRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.main.MainResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestBuilderListener;

public class RestMainAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/"), new RestHandler.Route(RestRequest.Method.HEAD, "/")));
    }

    @Override
    public String getName() {
        return "main_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return channel -> client.execute(MainAction.INSTANCE, new MainRequest(), new RestBuilderListener<MainResponse>(channel){

            @Override
            public RestResponse buildResponse(MainResponse mainResponse, XContentBuilder builder) throws Exception {
                return RestMainAction.convertMainResponse(mainResponse, request, builder);
            }
        });
    }

    static BytesRestResponse convertMainResponse(MainResponse response, RestRequest request, XContentBuilder builder) throws IOException {
        if (!request.hasParam("pretty")) {
            builder.prettyPrint().lfAtEnd();
        }
        response.toXContent(builder, request);
        return new BytesRestResponse(RestStatus.OK, builder);
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

