/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.os;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.SingleObjectCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.EsExecutors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.os.OsInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.os.OsProbe;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.os.OsStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.node.ReportingService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OsService
implements ReportingService<OsInfo> {
    private static final Logger logger = LogManager.getLogger(OsService.class);
    private final OsProbe probe = OsProbe.getInstance();
    private final OsInfo info;
    private final SingleObjectCache<OsStats> osStatsCache;
    public static final Setting<TimeValue> REFRESH_INTERVAL_SETTING = Setting.timeSetting("monitor.os.refresh_interval", TimeValue.timeValueSeconds(1L), TimeValue.timeValueSeconds(1L), Setting.Property.NodeScope);

    public OsService(Settings settings) throws IOException {
        TimeValue refreshInterval = REFRESH_INTERVAL_SETTING.get(settings);
        this.info = this.probe.osInfo(refreshInterval.millis(), EsExecutors.allocatedProcessors(settings));
        this.osStatsCache = new OsStatsCache(refreshInterval, this.probe.osStats());
        logger.debug("using refresh_interval [{}]", (Object)refreshInterval);
    }

    @Override
    public OsInfo info() {
        return this.info;
    }

    public synchronized OsStats stats() {
        return this.osStatsCache.getOrRefresh();
    }

    private class OsStatsCache
    extends SingleObjectCache<OsStats> {
        OsStatsCache(TimeValue interval, OsStats initValue) {
            super(interval, initValue);
        }

        @Override
        protected OsStats refresh() {
            return OsService.this.probe.osStats();
        }
    }
}

