/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog;

import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.InputStreamDataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.OutputStreamDataOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.BufferedChecksumStreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.Translog;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.TranslogCorruptedException;

final class TranslogHeader {
    public static final String TRANSLOG_CODEC = "translog";
    public static final int VERSION_CHECKSUMS = 1;
    public static final int VERSION_CHECKPOINTS = 2;
    public static final int VERSION_PRIMARY_TERM = 3;
    public static final int CURRENT_VERSION = 3;
    private final String translogUUID;
    private final long primaryTerm;
    private final int headerSizeInBytes;

    TranslogHeader(String translogUUID, long primaryTerm) {
        this(translogUUID, primaryTerm, TranslogHeader.headerSizeInBytes(translogUUID));
        assert (primaryTerm >= 0L) : "Primary term must be non-negative; term [" + primaryTerm + "]";
    }

    private TranslogHeader(String translogUUID, long primaryTerm, int headerSizeInBytes) {
        this.translogUUID = translogUUID;
        this.primaryTerm = primaryTerm;
        this.headerSizeInBytes = headerSizeInBytes;
    }

    public String getTranslogUUID() {
        return this.translogUUID;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public int sizeInBytes() {
        return this.headerSizeInBytes;
    }

    static int headerSizeInBytes(String translogUUID) {
        return TranslogHeader.headerSizeInBytes(3, new BytesRef((CharSequence)translogUUID).length);
    }

    private static int headerSizeInBytes(int version, int uuidLength) {
        int size = CodecUtil.headerLength(TRANSLOG_CODEC);
        size += 4 + uuidLength;
        if (version >= 3) {
            size += 8;
            size += 4;
        }
        return size;
    }

    static int readHeaderVersion(Path path, FileChannel channel, StreamInput in) throws IOException {
        int version;
        try {
            version = CodecUtil.checkHeader(new InputStreamDataInput(in), TRANSLOG_CODEC, 1, 3);
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException e) {
            TranslogHeader.tryReportOldVersionError(path, channel);
            throw new TranslogCorruptedException(path.toString(), "translog header corrupted", e);
        }
        if (version == 1) {
            throw new IllegalStateException("pre-2.0 translog found [" + path + "]");
        }
        return version;
    }

    static TranslogHeader read(String translogUUID, Path path, FileChannel channel) throws IOException {
        try {
            long primaryTerm;
            BufferedChecksumStreamInput in = new BufferedChecksumStreamInput(new InputStreamStreamInput(Channels.newInputStream(channel), channel.size()), path.toString());
            int version = TranslogHeader.readHeaderVersion(path, channel, in);
            int uuidLen = in.readInt();
            if ((long)uuidLen > channel.size()) {
                throw new TranslogCorruptedException(path.toString(), "UUID length can't be larger than the translog");
            }
            if (uuidLen <= 0) {
                throw new TranslogCorruptedException(path.toString(), "UUID length must be positive");
            }
            BytesRef uuid = new BytesRef(uuidLen);
            uuid.length = uuidLen;
            in.read(uuid.bytes, uuid.offset, uuid.length);
            if (version == 3) {
                primaryTerm = in.readLong();
            } else {
                assert (version == 2) : "Unknown header version [" + version + "]";
                primaryTerm = 0L;
            }
            if (version >= 3) {
                Translog.verifyChecksum(in);
            }
            assert (primaryTerm >= 0L) : "Primary term must be non-negative [" + primaryTerm + "]; translog path [" + path + "]";
            int headerSizeInBytes = TranslogHeader.headerSizeInBytes(version, uuid.length);
            assert (channel.position() == (long)headerSizeInBytes) : "Header is not fully read; header size [" + headerSizeInBytes + "], position [" + channel.position() + "]";
            BytesRef expectedUUID = new BytesRef(translogUUID);
            if (!uuid.bytesEquals(expectedUUID)) {
                throw new TranslogCorruptedException(path.toString(), "expected shard UUID " + expectedUUID + " but got: " + uuid + " this translog file belongs to a different translog");
            }
            return new TranslogHeader(translogUUID, primaryTerm, headerSizeInBytes);
        }
        catch (EOFException e) {
            throw new TranslogCorruptedException(path.toString(), "translog header truncated", e);
        }
    }

    private static void tryReportOldVersionError(Path path, FileChannel channel) throws IOException {
        byte b1 = org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.Channels.readFromFileChannel(channel, 0L, 1)[0];
        if (b1 == 63) {
            throw new TranslogCorruptedException(path.toString(), "translog looks like version 1 or later, but has corrupted header");
        }
        if (b1 == 0) {
            throw new IllegalStateException("pre-1.4 translog found [" + path + "]");
        }
    }

    void write(FileChannel channel) throws IOException {
        BufferedChecksumStreamOutput out = new BufferedChecksumStreamOutput(new OutputStreamStreamOutput(Channels.newOutputStream(channel)));
        CodecUtil.writeHeader(new OutputStreamDataOutput(out), TRANSLOG_CODEC, 3);
        BytesRef uuid = new BytesRef(this.translogUUID);
        out.writeInt(uuid.length);
        out.writeBytes(uuid.bytes, uuid.offset, uuid.length);
        out.writeLong(this.primaryTerm);
        out.writeInt((int)out.getChecksum());
        out.flush();
        channel.force(true);
        assert (channel.position() == (long)this.headerSizeInBytes) : "Header is not fully written; header size [" + this.headerSizeInBytes + "], channel position [" + channel.position() + "]";
    }
}

