/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.time.ZoneId;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.geo.ShapeRelation;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.time.DateMathParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.ConstantIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ConstantFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SearchLookup;

public class TypeFieldMapper
extends MetadataFieldMapper {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(TypeFieldType.class);
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using the _type field in queries and aggregations is deprecated, prefer to use a field instead.";
    public static final String NAME = "_type";
    public static final String CONTENT_TYPE = "_type";
    public static final MetadataFieldMapper.TypeParser PARSER = new MetadataFieldMapper.FixedTypeParser(c -> new TypeFieldMapper());

    public static void emitTypesDeprecationWarning() {
        deprecationLogger.deprecate("query_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
    }

    private TypeFieldMapper() {
        super(new TypeFieldType(null));
    }

    @Override
    public void preParse(ParseContext context) {
        if (this.fieldType.indexOptions() == IndexOptions.NONE && !this.fieldType.stored()) {
            return;
        }
        context.doc().add(new Field(this.fieldType().name(), context.sourceToParse().type(), (IndexableFieldType)this.fieldType));
        if (this.fieldType().hasDocValues()) {
            context.doc().add(new SortedSetDocValuesField(this.fieldType().name(), new BytesRef("_doc")));
        }
    }

    @Override
    protected String contentType() {
        return "_type";
    }

    public static final class TypeFieldType
    extends ConstantFieldType {
        private final String type;

        public TypeFieldType(String type) {
            super("_type", Collections.emptyMap());
            this.type = type;
        }

        @Override
        public String typeName() {
            return "_type";
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            return new ConstantIndexFieldData.Builder(this.type, this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup lookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.name() + "].");
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            return new MatchAllDocsQuery();
        }

        @Override
        protected boolean matches(String pattern, boolean caseInsensitive, QueryShardContext context) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            if (this.type == null) {
                return false;
            }
            return Regex.simpleMatch(pattern, this.type, caseInsensitive);
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            TypeFieldMapper.emitTypesDeprecationWarning();
            BytesRef lower = (BytesRef)lowerTerm;
            BytesRef upper = (BytesRef)upperTerm;
            if (includeLower ? lower.utf8ToString().compareTo(this.type) > 0 : lower.utf8ToString().compareTo(this.type) >= 0) {
                return new MatchNoDocsQuery();
            }
            if (includeUpper ? upper.utf8ToString().compareTo(this.type) < 0 : upper.utf8ToString().compareTo(this.type) <= 0) {
                return new MatchNoDocsQuery();
            }
            return new MatchAllDocsQuery();
        }

        public Query typeFilter(String[] types) {
            for (String t : types) {
                if (!Objects.equals(this.type, t)) continue;
                return new MatchAllDocsQuery();
            }
            return new MatchNoDocsQuery();
        }
    }

    public static class Defaults {
        public static final FieldType NESTED_FIELD_TYPE = new FieldType();

        static {
            NESTED_FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            NESTED_FIELD_TYPE.setTokenized(false);
            NESTED_FIELD_TYPE.setStored(false);
            NESTED_FIELD_TYPE.setOmitNorms(true);
            NESTED_FIELD_TYPE.freeze();
        }
    }
}

