/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Explicit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParametrizedFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;

public abstract class MetadataFieldMapper
extends ParametrizedFieldMapper {
    public static ParametrizedFieldMapper.Parameter<Explicit<Boolean>> updateableBoolParam(String name, Function<FieldMapper, Explicit<Boolean>> initializer, boolean defaultValue) {
        Explicit<Boolean> defaultExplicit = new Explicit<Boolean>(defaultValue, false);
        return new ParametrizedFieldMapper.Parameter<Explicit<Boolean>>(name, true, () -> defaultExplicit, (n, c, o) -> new Explicit<Boolean>(XContentMapValues.nodeBooleanValue(o), true), initializer).setSerializer((b, n, v) -> b.field(n, (Boolean)v.value()), v -> Boolean.toString((Boolean)v.value()));
    }

    protected MetadataFieldMapper(MappedFieldType mappedFieldType) {
        super(mappedFieldType.name(), mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
    }

    @Override
    public ParametrizedFieldMapper.Builder getMergeBuilder() {
        return null;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Builder mergeBuilder = (Builder)this.getMergeBuilder();
        if (mergeBuilder == null || !mergeBuilder.isConfigured()) {
            return builder;
        }
        builder.startObject(this.simpleName());
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        this.getMergeBuilder().toXContent(builder, includeDefaults);
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        throw new MapperParsingException("Field [" + this.name() + "] is a metadata field and cannot be added inside a document. Use the index API request parameters.");
    }

    public void preParse(ParseContext context) throws IOException {
    }

    public void postParse(ParseContext context) throws IOException {
    }

    public static abstract class Builder
    extends ParametrizedFieldMapper.Builder {
        protected Builder(String name) {
            super(name);
        }

        boolean isConfigured() {
            for (ParametrizedFieldMapper.Parameter<?> param : this.getParameters()) {
                if (!param.isConfigured()) continue;
                return true;
            }
            return false;
        }

        @Override
        public abstract MetadataFieldMapper build(Mapper.BuilderContext var1);
    }

    public static class ConfigurableTypeParser
    implements TypeParser {
        final Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> defaultMapperParser;
        final Function<Mapper.TypeParser.ParserContext, Builder> builderFunction;

        public ConfigurableTypeParser(Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> defaultMapperParser, Function<Mapper.TypeParser.ParserContext, Builder> builderFunction) {
            this.defaultMapperParser = defaultMapperParser;
            this.builderFunction = builderFunction;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = this.builderFunction.apply(parserContext);
            builder.parse(name, parserContext, node);
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType defaultFieldType, Mapper.TypeParser.ParserContext parserContext) {
            return this.defaultMapperParser.apply(parserContext);
        }
    }

    public static class FixedTypeParser
    implements TypeParser {
        final Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> mapperParser;

        public FixedTypeParser(Function<Mapper.TypeParser.ParserContext, MetadataFieldMapper> mapperParser) {
            this.mapperParser = mapperParser;
        }

        @Override
        public Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            throw new MapperParsingException(name + " is not configurable");
        }

        @Override
        public MetadataFieldMapper getDefault(MappedFieldType defaultFieldType, Mapper.TypeParser.ParserContext parserContext) {
            return this.mapperParser.apply(parserContext);
        }
    }

    public static interface TypeParser
    extends Mapper.TypeParser {
        public Builder parse(String var1, Map<String, Object> var2, Mapper.TypeParser.ParserContext var3) throws MapperParsingException;

        public MetadataFieldMapper getDefault(MappedFieldType var1, Mapper.TypeParser.ParserContext var2);
    }
}

