/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.get;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DocValuesType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.FieldInfo;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.StoredFieldVisitor;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.document.DocumentField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.uid.VersionsAndSeqNoResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.CounterMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.metrics.MeanMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.TranslogLeafReader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fieldvisitor.FieldsVisitor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.get.GetResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.get.GetStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParsedDocument;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceToParse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Uid;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public final class ShardGetService
extends AbstractIndexShardComponent {
    private final MapperService mapperService;
    private final MeanMetric existsMetric = new MeanMetric();
    private final MeanMetric missingMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final IndexShard indexShard;

    public ShardGetService(IndexSettings indexSettings, IndexShard indexShard, MapperService mapperService) {
        super(indexShard.shardId(), indexSettings);
        this.mapperService = mapperService;
        this.indexShard = indexShard;
    }

    public GetStats stats() {
        return new GetStats(this.existsMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.existsMetric.sum()), this.missingMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.missingMetric.sum()), this.currentMetric.count());
    }

    public GetResult get(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, FetchSourceContext fetchSourceContext) {
        return this.get(type, id, gFields, realtime, version, versionType, -2L, 0L, fetchSourceContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult get(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) {
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            GetResult getResult = this.innerGet(type, id, gFields, realtime, version, versionType, ifSeqNo, ifPrimaryTerm, fetchSourceContext);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    public GetResult getForUpdate(String type, String id, long ifSeqNo, long ifPrimaryTerm) {
        return this.get(type, id, new String[]{"_routing"}, true, -3L, VersionType.INTERNAL, ifSeqNo, ifPrimaryTerm, FetchSourceContext.FETCH_SOURCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GetResult get(Engine.GetResult engineGetResult, String id, String type, String[] fields, FetchSourceContext fetchSourceContext) {
        if (!engineGetResult.exists()) {
            return new GetResult(this.shardId.getIndexName(), type, id, -2L, 0L, -1L, false, null, null, null);
        }
        this.currentMetric.inc();
        try {
            long now = System.nanoTime();
            fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, fields);
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, fields, fetchSourceContext, engineGetResult, this.mapperService);
            if (getResult.isExists()) {
                this.existsMetric.inc(System.nanoTime() - now);
            } else {
                this.missingMetric.inc(System.nanoTime() - now);
            }
            GetResult getResult2 = getResult;
            return getResult2;
        }
        finally {
            this.currentMetric.dec();
        }
    }

    private FetchSourceContext normalizeFetchSourceContent(@Nullable FetchSourceContext context, @Nullable String[] gFields) {
        if (context != null) {
            return context;
        }
        if (gFields == null) {
            return FetchSourceContext.FETCH_SOURCE;
        }
        for (String field : gFields) {
            if (!"_source".equals(field)) continue;
            return FetchSourceContext.FETCH_SOURCE;
        }
        return FetchSourceContext.DO_NOT_FETCH_SOURCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GetResult innerGet(String type, String id, String[] gFields, boolean realtime, long version, VersionType versionType, long ifSeqNo, long ifPrimaryTerm, FetchSourceContext fetchSourceContext) {
        fetchSourceContext = this.normalizeFetchSourceContent(fetchSourceContext, gFields);
        if (type == null || type.equals("_all")) {
            DocumentMapper mapper = this.mapperService.documentMapper();
            type = mapper == null ? null : mapper.type();
        }
        Engine.GetResult get = null;
        if (type != null) {
            Term uidTerm = new Term("_id", Uid.encodeId(id));
            get = this.indexShard.get(new Engine.Get(realtime, realtime, type, id, uidTerm).version(version).versionType(versionType).setIfSeqNo(ifSeqNo).setIfPrimaryTerm(ifPrimaryTerm));
            assert (!get.isFromTranslog() || realtime) : "should only read from translog if realtime enabled";
            if (!get.exists()) {
                get.close();
            }
        }
        if (get == null || !get.exists()) {
            return new GetResult(this.shardId.getIndexName(), type, id, -2L, 0L, -1L, false, null, null, null);
        }
        try {
            GetResult getResult = this.innerGetLoadFromStoredFields(type, id, gFields, fetchSourceContext, get, this.mapperService);
            return getResult;
        }
        finally {
            get.close();
        }
    }

    private GetResult innerGetLoadFromStoredFields(String type, String id, String[] storedFields, FetchSourceContext fetchSourceContext, Engine.GetResult get, MapperService mapperService) {
        Map<String, Object> sourceAsMap;
        XContentType sourceContentType;
        assert (get.exists()) : "method should only be called if document could be retrieved";
        DocumentMapper docMapper = mapperService.documentMapper();
        if (storedFields != null) {
            for (String field : storedFields) {
                Mapper fieldMapper = docMapper.mappers().getMapper(field);
                if (fieldMapper != null || docMapper.objectMappers().get(field) == null) continue;
                throw new IllegalArgumentException("field [" + field + "] isn't a leaf field");
            }
        }
        HashMap<String, DocumentField> documentFields = null;
        HashMap<String, DocumentField> metadataFields = null;
        BytesReference source = null;
        VersionsAndSeqNoResolver.DocIdAndVersion docIdAndVersion = get.docIdAndVersion();
        boolean forceSourceForComputingTranslogStoredFields = get.isFromTranslog() && storedFields != null && Stream.of(storedFields).anyMatch(f -> !TranslogLeafReader.ALL_FIELD_NAMES.contains(f));
        FieldsVisitor fieldVisitor = ShardGetService.buildFieldsVisitors(storedFields, forceSourceForComputingTranslogStoredFields ? FetchSourceContext.FETCH_SOURCE : fetchSourceContext);
        if (fieldVisitor != null) {
            try {
                docIdAndVersion.reader.document(docIdAndVersion.docId, fieldVisitor);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get type [" + type + "] and id [" + id + "]", (Throwable)e, new Object[0]);
            }
            source = fieldVisitor.source();
            if (get.isFromTranslog()) {
                if (!forceSourceForComputingTranslogStoredFields) {
                    try {
                        source = this.indexShard.mapperService().documentMapper().sourceMapper().applyFilters(source, null);
                    }
                    catch (IOException e) {
                        throw new ElasticsearchException("Failed to reapply filters for [" + id + "] after reading from translog", (Throwable)e, new Object[0]);
                    }
                } else {
                    assert (source != null) : "original source in translog must exist";
                    SourceToParse sourceToParse = new SourceToParse(this.shardId.getIndexName(), type, id, source, XContentHelper.xContentType(source), fieldVisitor.routing());
                    ParsedDocument parsedDocument = this.indexShard.mapperService().documentMapper().parse(sourceToParse);
                    assert (parsedDocument.dynamicMappingsUpdate() == null) : "mapping updates should not be required on already-indexed doc";
                    parsedDocument.updateSeqID(docIdAndVersion.seqNo, docIdAndVersion.primaryTerm);
                    parsedDocument.version().setLongValue(docIdAndVersion.version);
                    fieldVisitor = ShardGetService.buildFieldsVisitors(storedFields, fetchSourceContext);
                    for (IndexableField indexableField : parsedDocument.rootDoc().getFields()) {
                        IndexableFieldType fieldType = indexableField.fieldType();
                        if (!fieldType.stored()) continue;
                        FieldInfo fieldInfo = new FieldInfo(indexableField.name(), 0, false, false, false, IndexOptions.NONE, DocValuesType.NONE, -1L, Collections.emptyMap(), 0, 0, 0, false);
                        StoredFieldVisitor.Status status = fieldVisitor.needsField(fieldInfo);
                        if (status == StoredFieldVisitor.Status.YES) {
                            if (indexableField.numericValue() != null) {
                                fieldVisitor.objectField(fieldInfo, indexableField.numericValue());
                                continue;
                            }
                            if (indexableField.binaryValue() != null) {
                                fieldVisitor.binaryField(fieldInfo, indexableField.binaryValue());
                                continue;
                            }
                            if (indexableField.stringValue() == null) continue;
                            fieldVisitor.objectField(fieldInfo, indexableField.stringValue());
                            continue;
                        }
                        if (status != StoredFieldVisitor.Status.STOP) continue;
                        break;
                    }
                    source = fieldVisitor.source();
                }
            }
            if (!fieldVisitor.fields().isEmpty()) {
                fieldVisitor.postProcess(mapperService);
                documentFields = new HashMap<String, DocumentField>();
                metadataFields = new HashMap<String, DocumentField>();
                for (Map.Entry entry : fieldVisitor.fields().entrySet()) {
                    if (mapperService.isMetadataField((String)entry.getKey())) {
                        metadataFields.put((String)entry.getKey(), new DocumentField((String)entry.getKey(), (List)entry.getValue()));
                        continue;
                    }
                    documentFields.put((String)entry.getKey(), new DocumentField((String)entry.getKey(), (List)entry.getValue()));
                }
            }
        }
        if (source != null) {
            if (!fetchSourceContext.fetchSource()) {
                source = null;
            } else if (fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0) {
                Tuple<XContentType, Map<String, Object>> tuple = XContentHelper.convertToMap(source, true);
                sourceContentType = tuple.v1();
                sourceAsMap = tuple.v2();
                sourceAsMap = XContentMapValues.filter(sourceAsMap, fetchSourceContext.includes(), fetchSourceContext.excludes());
                try {
                    source = BytesReference.bytes(XContentFactory.contentBuilder(sourceContentType).map(sourceAsMap));
                }
                catch (IOException e) {
                    throw new ElasticsearchException("Failed to get id [" + id + "] with includes/excludes set", (Throwable)e, new Object[0]);
                }
            }
        }
        if (!fetchSourceContext.fetchSource()) {
            source = null;
        }
        if (source != null && get.isFromTranslog()) {
            try {
                source = docMapper.sourceMapper().applyFilters(source, null);
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to reapply filters for [" + id + "] after reading from translog", (Throwable)e, new Object[0]);
            }
        }
        if (source != null && (fetchSourceContext.includes().length > 0 || fetchSourceContext.excludes().length > 0)) {
            Tuple<XContentType, Map<String, Object>> tuple = XContentHelper.convertToMap(source, true);
            sourceContentType = tuple.v1();
            sourceAsMap = tuple.v2();
            sourceAsMap = XContentMapValues.filter(sourceAsMap, fetchSourceContext.includes(), fetchSourceContext.excludes());
            try {
                source = BytesReference.bytes(XContentFactory.contentBuilder(sourceContentType).map(sourceAsMap));
            }
            catch (IOException e) {
                throw new ElasticsearchException("Failed to get type [" + type + "] and id [" + id + "] with includes/excludes set", (Throwable)e, new Object[0]);
            }
        }
        return new GetResult(this.shardId.getIndexName(), type, id, get.docIdAndVersion().seqNo, get.docIdAndVersion().primaryTerm, get.version(), get.exists(), source, documentFields, metadataFields);
    }

    private static FieldsVisitor buildFieldsVisitors(String[] fields, FetchSourceContext fetchSourceContext) {
        if (fields == null || fields.length == 0) {
            return fetchSourceContext.fetchSource() ? new FieldsVisitor(true) : null;
        }
        return new CustomFieldsVisitor(Sets.newHashSet(fields), fetchSourceContext.fetchSource());
    }
}

