/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.BinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SortedSetDocValues;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.BigArrays;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.BucketedSort;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.sort.SortOrder;

public class BytesRefFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexFieldData<?> indexFieldData;

    public BytesRefFieldComparatorSource(IndexFieldData<?> indexFieldData, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.STRING;
    }

    @Override
    public Object missingValue(boolean reversed) {
        if (this.sortMissingFirst(this.missingValue) || this.sortMissingLast(this.missingValue)) {
            if (this.sortMissingLast(this.missingValue) ^ reversed) {
                return SortField.STRING_LAST;
            }
            return SortField.STRING_FIRST;
        }
        return null;
    }

    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
        return this.indexFieldData.load(context).getBytesValues();
    }

    protected void setScorer(Scorable scorer) {
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        boolean sortMissingLast = this.sortMissingLast(this.missingValue) ^ reversed;
        final BytesRef missingBytes = (BytesRef)this.missingObject(this.missingValue, reversed);
        if (this.indexFieldData instanceof IndexOrdinalsFieldData) {
            return new FieldComparator.TermOrdValComparator(numHits, null, sortMissingLast){

                @Override
                protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                    SortedDocValues selectedValues;
                    SortedSetDocValues values = ((LeafOrdinalsFieldData)((IndexOrdinalsFieldData)BytesRefFieldComparatorSource.this.indexFieldData).load(context)).getOrdinalsValues();
                    if (BytesRefFieldComparatorSource.this.nested == null) {
                        selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values);
                    } else {
                        BitSet rootDocs = BytesRefFieldComparatorSource.this.nested.rootDocs(context);
                        DocIdSetIterator innerDocs = BytesRefFieldComparatorSource.this.nested.innerDocs(context);
                        int maxChildren = BytesRefFieldComparatorSource.this.nested.getNestedSort() != null ? BytesRefFieldComparatorSource.this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                        selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values, rootDocs, innerDocs, maxChildren);
                    }
                    if (BytesRefFieldComparatorSource.this.sortMissingFirst(BytesRefFieldComparatorSource.this.missingValue) || BytesRefFieldComparatorSource.this.sortMissingLast(BytesRefFieldComparatorSource.this.missingValue)) {
                        return selectedValues;
                    }
                    return new ReplaceMissing(selectedValues, missingBytes);
                }

                @Override
                public void setScorer(Scorable scorer) {
                    BytesRefFieldComparatorSource.this.setScorer(scorer);
                }
            };
        }
        return new FieldComparator.TermValComparator(numHits, null, sortMissingLast){

            @Override
            protected BinaryDocValues getBinaryDocValues(LeafReaderContext context, String field) throws IOException {
                BinaryDocValues selectedValues;
                SortedBinaryDocValues values = BytesRefFieldComparatorSource.this.getValues(context);
                if (BytesRefFieldComparatorSource.this.nested == null) {
                    selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values, missingBytes);
                } else {
                    BitSet rootDocs = BytesRefFieldComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = BytesRefFieldComparatorSource.this.nested.innerDocs(context);
                    int maxChildren = BytesRefFieldComparatorSource.this.nested.getNestedSort() != null ? BytesRefFieldComparatorSource.this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
                    selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values, missingBytes, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
                }
                return selectedValues;
            }

            @Override
            public void setScorer(Scorable scorer) {
                BytesRefFieldComparatorSource.this.setScorer(scorer);
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    static class ReplaceMissing
    extends AbstractSortedDocValues {
        final SortedDocValues in;
        final int substituteOrd;
        final BytesRef substituteTerm;
        final boolean exists;
        boolean hasValue;

        ReplaceMissing(SortedDocValues in, BytesRef term) throws IOException {
            this.in = in;
            this.substituteTerm = term;
            int sub = in.lookupTerm(term);
            if (sub < 0) {
                this.substituteOrd = -sub - 1;
                this.exists = false;
            } else {
                this.substituteOrd = sub;
                this.exists = true;
            }
        }

        @Override
        public int ordValue() throws IOException {
            if (!this.hasValue) {
                return this.substituteOrd;
            }
            int ord = this.in.ordValue();
            if (!this.exists && ord >= this.substituteOrd) {
                return ord + 1;
            }
            return ord;
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.hasValue = this.in.advanceExact(target);
            return true;
        }

        @Override
        public int docID() {
            return this.in.docID();
        }

        @Override
        public int getValueCount() {
            if (this.exists) {
                return this.in.getValueCount();
            }
            return this.in.getValueCount() + 1;
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            if (ord == this.substituteOrd) {
                return this.substituteTerm;
            }
            if (!this.exists && ord > this.substituteOrd) {
                return this.in.lookupOrd(ord - 1);
            }
            return this.in.lookupOrd(ord);
        }
    }
}

