/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.support;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public abstract class AbstractXContentParser
implements XContentParser {
    public static final boolean DEFAULT_NUMBER_COERCE_POLICY = true;
    private final NamedXContentRegistry xContentRegistry;
    private final DeprecationHandler deprecationHandler;
    private static BigInteger LONG_MAX_VALUE_AS_BIGINTEGER = BigInteger.valueOf(Long.MAX_VALUE);
    private static BigInteger LONG_MIN_VALUE_AS_BIGINTEGER = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigDecimal BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);
    private static final Supplier<Map<String, Object>> SIMPLE_MAP_FACTORY = HashMap::new;
    private static final Supplier<Map<String, Object>> ORDERED_MAP_FACTORY = LinkedHashMap::new;

    private static void checkCoerceString(boolean coerce, Class<? extends Number> clazz) {
        if (!coerce) {
            throw new IllegalArgumentException(clazz.getSimpleName() + " value passed as String");
        }
    }

    public AbstractXContentParser(NamedXContentRegistry xContentRegistry, DeprecationHandler deprecationHandler) {
        this.xContentRegistry = xContentRegistry;
        this.deprecationHandler = deprecationHandler;
    }

    void ensureNumberConversion(boolean coerce, long result, Class<? extends Number> clazz) throws IOException {
        double fullVal;
        if (!coerce && (double)result != (fullVal = this.doDoubleValue())) {
            throw new IllegalArgumentException(fullVal + " cannot be converted to " + clazz.getSimpleName() + " without data loss");
        }
    }

    @Override
    public boolean isBooleanValue() throws IOException {
        switch (this.currentToken()) {
            case VALUE_BOOLEAN: {
                return true;
            }
            case VALUE_STRING: {
                return Booleans.isBoolean(this.textCharacters(), this.textOffset(), this.textLength());
            }
        }
        return false;
    }

    @Override
    public boolean booleanValue() throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            return Booleans.parseBoolean(this.textCharacters(), this.textOffset(), this.textLength(), false);
        }
        return this.doBooleanValue();
    }

    protected abstract boolean doBooleanValue() throws IOException;

    @Override
    public short shortValue() throws IOException {
        return this.shortValue(true);
    }

    @Override
    public short shortValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Short.class);
            double doubleValue = Double.parseDouble(this.text());
            if (doubleValue < -32768.0 || doubleValue > 32767.0) {
                throw new IllegalArgumentException("Value [" + this.text() + "] is out of range for a short");
            }
            return (short)doubleValue;
        }
        short result = this.doShortValue();
        this.ensureNumberConversion(coerce, result, Short.class);
        return result;
    }

    protected abstract short doShortValue() throws IOException;

    @Override
    public int intValue() throws IOException {
        return this.intValue(true);
    }

    @Override
    public int intValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Integer.class);
            double doubleValue = Double.parseDouble(this.text());
            if (doubleValue < -2.147483648E9 || doubleValue > 2.147483647E9) {
                throw new IllegalArgumentException("Value [" + this.text() + "] is out of range for an integer");
            }
            return (int)doubleValue;
        }
        int result = this.doIntValue();
        this.ensureNumberConversion(coerce, result, Integer.class);
        return result;
    }

    protected abstract int doIntValue() throws IOException;

    private static long toLong(String stringValue, boolean coerce) {
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            BigInteger bigIntegerValue;
            try {
                BigDecimal bigDecimalValue = new BigDecimal(stringValue);
                if (bigDecimalValue.compareTo(BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE) >= 0 || bigDecimalValue.compareTo(BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE) <= 0) {
                    throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
                }
                bigIntegerValue = coerce ? bigDecimalValue.toBigInteger() : bigDecimalValue.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Value [" + stringValue + "] has a decimal part");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
            }
            if (bigIntegerValue.compareTo(LONG_MAX_VALUE_AS_BIGINTEGER) > 0 || bigIntegerValue.compareTo(LONG_MIN_VALUE_AS_BIGINTEGER) < 0) {
                throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
            }
            assert (bigIntegerValue.longValueExact() <= Long.MAX_VALUE);
            return bigIntegerValue.longValue();
        }
    }

    @Override
    public long longValue() throws IOException {
        return this.longValue(true);
    }

    @Override
    public long longValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Long.class);
            return AbstractXContentParser.toLong(this.text(), coerce);
        }
        long result = this.doLongValue();
        this.ensureNumberConversion(coerce, result, Long.class);
        return result;
    }

    protected abstract long doLongValue() throws IOException;

    @Override
    public float floatValue() throws IOException {
        return this.floatValue(true);
    }

    @Override
    public float floatValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Float.class);
            return Float.parseFloat(this.text());
        }
        return this.doFloatValue();
    }

    protected abstract float doFloatValue() throws IOException;

    @Override
    public double doubleValue() throws IOException {
        return this.doubleValue(true);
    }

    @Override
    public double doubleValue(boolean coerce) throws IOException {
        XContentParser.Token token = this.currentToken();
        if (token == XContentParser.Token.VALUE_STRING) {
            AbstractXContentParser.checkCoerceString(coerce, Double.class);
            return Double.parseDouble(this.text());
        }
        return this.doDoubleValue();
    }

    protected abstract double doDoubleValue() throws IOException;

    @Override
    public final String textOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.text();
    }

    @Override
    public CharBuffer charBufferOrNull() throws IOException {
        if (this.currentToken() == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        return this.charBuffer();
    }

    @Override
    public Map<String, Object> map() throws IOException {
        return AbstractXContentParser.readMapSafe(this, SIMPLE_MAP_FACTORY);
    }

    @Override
    public Map<String, Object> mapOrdered() throws IOException {
        return AbstractXContentParser.readMapSafe(this, ORDERED_MAP_FACTORY);
    }

    @Override
    public Map<String, String> mapStrings() throws IOException {
        return this.map(HashMap::new, XContentParser::text);
    }

    @Override
    public <T> Map<String, T> map(Supplier<Map<String, T>> mapFactory, CheckedFunction<XContentParser, T, IOException> mapValueParser) throws IOException {
        Map<String, T> map = mapFactory.get();
        if (!AbstractXContentParser.findNonEmptyMapStart(this)) {
            return map;
        }
        assert (this.currentToken() == XContentParser.Token.FIELD_NAME) : "Expected field name but saw [" + (Object)((Object)this.currentToken()) + "]";
        do {
            String fieldName = this.currentName();
            this.nextToken();
            T value = mapValueParser.apply(this);
            map.put(fieldName, value);
        } while (this.nextToken() == XContentParser.Token.FIELD_NAME);
        return map;
    }

    @Override
    public List<Object> list() throws IOException {
        AbstractXContentParser.skipToListStart(this);
        return AbstractXContentParser.readListUnsafe(this, SIMPLE_MAP_FACTORY);
    }

    @Override
    public List<Object> listOrderedMap() throws IOException {
        AbstractXContentParser.skipToListStart(this);
        return AbstractXContentParser.readListUnsafe(this, ORDERED_MAP_FACTORY);
    }

    private static Map<String, Object> readMapSafe(XContentParser parser, Supplier<Map<String, Object>> mapFactory) throws IOException {
        Map<String, Object> map = mapFactory.get();
        return AbstractXContentParser.findNonEmptyMapStart(parser) ? AbstractXContentParser.readMapEntries(parser, mapFactory, map) : map;
    }

    private static Map<String, Object> readMapEntries(XContentParser parser, Supplier<Map<String, Object>> mapFactory, Map<String, Object> map) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.FIELD_NAME) : "Expected field name but saw [" + (Object)((Object)parser.currentToken()) + "]";
        do {
            String fieldName = parser.currentName();
            Object value = AbstractXContentParser.readValueUnsafe(parser.nextToken(), parser, mapFactory);
            map.put(fieldName, value);
        } while (parser.nextToken() == XContentParser.Token.FIELD_NAME);
        return map;
    }

    private static boolean findNonEmptyMapStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.START_OBJECT) {
            token = parser.nextToken();
        }
        return token == XContentParser.Token.FIELD_NAME;
    }

    private static void skipToListStart(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        if (token == XContentParser.Token.FIELD_NAME) {
            token = parser.nextToken();
        }
        if (token != XContentParser.Token.START_ARRAY) {
            throw new XContentParseException(parser.getTokenLocation(), "Failed to parse list:  expecting " + (Object)((Object)XContentParser.Token.START_ARRAY) + " but got " + (Object)((Object)token));
        }
    }

    private static List<Object> readListUnsafe(XContentParser parser, Supplier<Map<String, Object>> mapFactory) throws IOException {
        assert (parser.currentToken() == XContentParser.Token.START_ARRAY);
        ArrayList<Object> list = new ArrayList<Object>();
        XContentParser.Token token = parser.nextToken();
        while (token != null && token != XContentParser.Token.END_ARRAY) {
            list.add(AbstractXContentParser.readValueUnsafe(token, parser, mapFactory));
            token = parser.nextToken();
        }
        return list;
    }

    public static Object readValue(XContentParser parser, Supplier<Map<String, Object>> mapFactory) throws IOException {
        return AbstractXContentParser.readValueUnsafe(parser.currentToken(), parser, mapFactory);
    }

    private static Object readValueUnsafe(XContentParser.Token currentToken, XContentParser parser, Supplier<Map<String, Object>> mapFactory) throws IOException {
        assert (currentToken == parser.currentToken()) : "Supplied current token [" + (Object)((Object)currentToken) + "] is different from actual parser current token [" + (Object)((Object)parser.currentToken()) + "]";
        switch (currentToken) {
            case VALUE_STRING: {
                return parser.text();
            }
            case VALUE_NUMBER: {
                return parser.numberValue();
            }
            case VALUE_BOOLEAN: {
                return parser.booleanValue();
            }
            case START_OBJECT: {
                Map<String, Object> map = mapFactory.get();
                return parser.nextToken() != XContentParser.Token.FIELD_NAME ? map : AbstractXContentParser.readMapEntries(parser, mapFactory, map);
            }
            case START_ARRAY: {
                return AbstractXContentParser.readListUnsafe(parser, mapFactory);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return parser.binaryValue();
            }
        }
        return null;
    }

    @Override
    public <T> T namedObject(Class<T> categoryClass, String name, Object context) throws IOException {
        return this.xContentRegistry.parseNamedObject(categoryClass, name, this, context);
    }

    @Override
    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    @Override
    public abstract boolean isClosed();

    @Override
    public DeprecationHandler getDeprecationHandler() {
        return this.deprecationHandler;
    }
}

