/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.Countable;

public class PlainIterator<T>
implements Iterable<T>,
Countable {
    private final List<T> elements;
    private volatile int index;

    public PlainIterator(List<T> elements) {
        this.elements = elements;
        this.reset();
    }

    public void reset() {
        this.index = 0;
    }

    public int remaining() {
        return this.elements.size() - this.index;
    }

    public T nextOrNull() {
        if (this.index == this.elements.size()) {
            return null;
        }
        return this.elements.get(this.index++);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public List<T> asList() {
        return Collections.unmodifiableList(this.elements);
    }

    @Override
    public Iterator<T> iterator() {
        return this.elements.iterator();
    }
}

