/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Base64;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.CodecUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.DataInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexOutput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.SimpleFSDirectory;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SetOnce;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cli.UserException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Randomness;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.hash.MessageDigests;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SecureSetting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SecureSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SecureString;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;

public class KeyStoreWrapper
implements SecureSettings {
    private static final Pattern ALLOWED_SETTING_NAME = Pattern.compile("[A-Za-z0-9_\\-.]+");
    public static final Setting<SecureString> SEED_SETTING = SecureSetting.secureString("keystore.seed", null, new Setting.Property[0]);
    private static final char[] SEED_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789~!@#$%^&*-_=+?".toCharArray();
    private static final String KEYSTORE_FILENAME = "elasticsearch.keystore";
    static final int FORMAT_VERSION = 4;
    private static final int MIN_FORMAT_VERSION = 1;
    private static final String KDF_ALGO = "PBKDF2WithHmacSHA512";
    private static final int KDF_ITERS = 10000;
    private static final int CIPHER_KEY_BITS = 128;
    private static final int GCM_TAG_BITS = 128;
    private static final String CIPHER_ALGO = "AES";
    private static final String CIPHER_MODE = "GCM";
    private static final String CIPHER_PADDING = "NoPadding";
    private final int formatVersion;
    private final boolean hasPassword;
    private final byte[] dataBytes;
    private final SetOnce<Map<String, Entry>> entries = new SetOnce();
    private volatile boolean closed;

    private KeyStoreWrapper(int formatVersion, boolean hasPassword, byte[] dataBytes) {
        this.formatVersion = formatVersion;
        this.hasPassword = hasPassword;
        this.dataBytes = dataBytes;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public static Path keystorePath(Path configDir) {
        return configDir.resolve(KEYSTORE_FILENAME);
    }

    public static KeyStoreWrapper create() {
        KeyStoreWrapper wrapper = new KeyStoreWrapper(4, false, null);
        wrapper.entries.set(new HashMap());
        KeyStoreWrapper.addBootstrapSeed(wrapper);
        return wrapper;
    }

    public static void addBootstrapSeed(KeyStoreWrapper wrapper) {
        assert (!wrapper.getSettingNames().contains(SEED_SETTING.getKey()));
        SecureRandom random = Randomness.createSecure();
        int passwordLength = 20;
        char[] characters = new char[passwordLength];
        for (int i = 0; i < passwordLength; ++i) {
            characters[i] = SEED_CHARS[random.nextInt(SEED_CHARS.length)];
        }
        wrapper.setString(SEED_SETTING.getKey(), characters);
        Arrays.fill(characters, '\u0000');
    }

    public static KeyStoreWrapper load(Path configDir) throws IOException {
        Path keystoreFile = KeyStoreWrapper.keystorePath(configDir);
        if (!Files.exists(keystoreFile, new LinkOption[0])) {
            return null;
        }
        SimpleFSDirectory directory = new SimpleFSDirectory(configDir);
        try (IndexInput indexInput = directory.openInput(KEYSTORE_FILENAME, IOContext.READONCE);){
            byte[] dataBytes;
            boolean hasPassword;
            int formatVersion;
            BufferedChecksumIndexInput input = new BufferedChecksumIndexInput(indexInput);
            try {
                formatVersion = CodecUtil.checkHeader(input, KEYSTORE_FILENAME, 1, 4);
            }
            catch (IndexFormatTooOldException e) {
                throw new IllegalStateException("The Elasticsearch keystore [" + keystoreFile + "] format is too old. You should delete and recreate it in order to upgrade.", e);
            }
            catch (IndexFormatTooNewException e) {
                throw new IllegalStateException("The Elasticsearch keystore [" + keystoreFile + "] format is too new. Are you trying to downgrade? You should delete and recreate it in order to downgrade.", e);
            }
            byte hasPasswordByte = ((DataInput)input).readByte();
            boolean bl = hasPassword = hasPasswordByte == 1;
            if (!hasPassword && hasPasswordByte != 0) {
                throw new IllegalStateException("hasPassword boolean is corrupt: " + String.format(Locale.ROOT, "%02x", hasPasswordByte));
            }
            if (formatVersion <= 2) {
                String fileKeyAlgo;
                String type = input.readString();
                if (!type.equals("PKCS12")) {
                    throw new IllegalStateException("Corrupted legacy keystore string encryption algorithm");
                }
                String stringKeyAlgo = input.readString();
                if (!stringKeyAlgo.equals("PBE")) {
                    throw new IllegalStateException("Corrupted legacy keystore string encryption algorithm");
                }
                if (formatVersion == 2 && !(fileKeyAlgo = input.readString()).equals("PBE")) {
                    throw new IllegalStateException("Corrupted legacy keystore file encryption algorithm");
                }
            }
            if (formatVersion == 2) {
                Map<String, String> settingTypes = input.readMapOfStrings();
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try (DataOutputStream output = new DataOutputStream(bytes);){
                    output.writeInt(settingTypes.size());
                    for (Map.Entry<String, String> entry : settingTypes.entrySet()) {
                        output.writeUTF(entry.getKey());
                        output.writeUTF(entry.getValue());
                    }
                    int keystoreLen = input.readInt();
                    byte[] keystoreBytes = new byte[keystoreLen];
                    ((DataInput)input).readBytes(keystoreBytes, 0, keystoreLen);
                    output.write(keystoreBytes);
                }
                dataBytes = bytes.toByteArray();
            } else {
                int dataBytesLen = input.readInt();
                dataBytes = new byte[dataBytesLen];
                ((DataInput)input).readBytes(dataBytes, 0, dataBytesLen);
            }
            CodecUtil.checkFooter(input);
            KeyStoreWrapper keyStoreWrapper = new KeyStoreWrapper(formatVersion, hasPassword, dataBytes);
            return keyStoreWrapper;
        }
    }

    public static void upgrade(KeyStoreWrapper wrapper, Path configDir, char[] password) throws Exception {
        if (wrapper.getFormatVersion() == 4 && wrapper.getSettingNames().contains(SEED_SETTING.getKey())) {
            return;
        }
        if (!wrapper.getSettingNames().contains(SEED_SETTING.getKey())) {
            KeyStoreWrapper.addBootstrapSeed(wrapper);
        }
        wrapper.save(configDir, password);
    }

    @Override
    public boolean isLoaded() {
        return this.entries.get() != null;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    private Cipher createCipher(int opmode, char[] password, byte[] salt, byte[] iv) throws GeneralSecurityException {
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, 10000, 128);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KDF_ALGO);
        SecretKey secretKey = keyFactory.generateSecret(keySpec);
        SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), CIPHER_ALGO);
        GCMParameterSpec spec = new GCMParameterSpec(128, iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(opmode, (Key)secret, spec);
        cipher.updateAAD(salt);
        return cipher;
    }

    public void decrypt(char[] password) throws GeneralSecurityException, IOException {
        byte[] encryptedBytes;
        byte[] iv;
        byte[] salt;
        if (this.entries.get() != null) {
            throw new IllegalStateException("Keystore has already been decrypted");
        }
        if (this.formatVersion <= 2) {
            this.decryptLegacyEntries();
            if (password.length != 0) {
                throw new IllegalArgumentException("Keystore format does not accept non-empty passwords");
            }
            return;
        }
        try (ByteArrayInputStream bytesStream = new ByteArrayInputStream(this.dataBytes);
             DataInputStream input = new DataInputStream(bytesStream);){
            int saltLen = input.readInt();
            salt = new byte[saltLen];
            input.readFully(salt);
            int ivLen = input.readInt();
            iv = new byte[ivLen];
            input.readFully(iv);
            int encryptedLen = input.readInt();
            encryptedBytes = new byte[encryptedLen];
            input.readFully(encryptedBytes);
            if (input.read() != -1) {
                throw new SecurityException("Keystore has been corrupted or tampered with");
            }
        }
        catch (EOFException e) {
            throw new SecurityException("Keystore has been corrupted or tampered with", e);
        }
        Cipher cipher = this.createCipher(2, password, salt, iv);
        try (ByteArrayInputStream bytesStream = new ByteArrayInputStream(encryptedBytes);
             CipherInputStream cipherStream = new CipherInputStream(bytesStream, cipher);
             DataInputStream input = new DataInputStream(cipherStream);){
            this.entries.set(new HashMap());
            int numEntries = input.readInt();
            while (numEntries-- > 0) {
                String setting = input.readUTF();
                if (this.formatVersion == 3) {
                    input.readUTF();
                }
                int entrySize = input.readInt();
                byte[] entryBytes = new byte[entrySize];
                input.readFully(entryBytes);
                this.entries.get().put(setting, new Entry(entryBytes));
            }
            if (input.read() != -1) {
                throw new SecurityException("Keystore has been corrupted or tampered with");
            }
        }
        catch (IOException e) {
            if (e.getCause() instanceof AEADBadTagException) {
                throw new SecurityException("Provided keystore password was incorrect", e);
            }
            throw new SecurityException("Keystore has been corrupted or tampered with", e);
        }
    }

    private byte[] encrypt(char[] password, byte[] salt, byte[] iv) throws GeneralSecurityException, IOException {
        assert (this.isLoaded());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        Cipher cipher = this.createCipher(1, password, salt, iv);
        try (CipherOutputStream cipherStream = new CipherOutputStream(bytes, cipher);
             DataOutputStream output = new DataOutputStream(cipherStream);){
            output.writeInt(this.entries.get().size());
            for (Map.Entry<String, Entry> mapEntry : this.entries.get().entrySet()) {
                output.writeUTF(mapEntry.getKey());
                byte[] entryBytes = mapEntry.getValue().bytes;
                output.writeInt(entryBytes.length);
                output.write(entryBytes);
            }
        }
        return bytes.toByteArray();
    }

    private void decryptLegacyEntries() throws GeneralSecurityException, IOException {
        KeyStore keystore = KeyStore.getInstance("PKCS12");
        HashMap<String, EntryType> settingTypes = new HashMap<String, EntryType>();
        ByteArrayInputStream inputBytes = new ByteArrayInputStream(this.dataBytes);
        try (DataInputStream input = new DataInputStream(inputBytes);){
            if (this.formatVersion == 2) {
                int numSettings = input.readInt();
                for (int i = 0; i < numSettings; ++i) {
                    String key = input.readUTF();
                    String value = input.readUTF();
                    settingTypes.put(key, EntryType.valueOf(value));
                }
            }
            keystore.load(input, "".toCharArray());
        }
        Enumeration<String> aliases = keystore.aliases();
        if (this.formatVersion == 1) {
            while (aliases.hasMoreElements()) {
                settingTypes.put(aliases.nextElement(), EntryType.STRING);
            }
        } else {
            HashSet expectedSettings = new HashSet(settingTypes.keySet());
            while (aliases.hasMoreElements()) {
                String settingName = aliases.nextElement();
                if (expectedSettings.remove(settingName)) continue;
                throw new SecurityException("Keystore has been corrupted or tampered with");
            }
            if (!expectedSettings.isEmpty()) {
                throw new SecurityException("Keystore has been corrupted or tampered with");
            }
        }
        this.entries.set(new HashMap());
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBE");
        KeyStore.PasswordProtection password = new KeyStore.PasswordProtection("".toCharArray());
        for (Map.Entry settingEntry : settingTypes.entrySet()) {
            byte[] bytes;
            String setting = (String)settingEntry.getKey();
            EntryType settingType = (EntryType)((Object)settingEntry.getValue());
            KeyStore.SecretKeyEntry keystoreEntry = (KeyStore.SecretKeyEntry)keystore.getEntry(setting, password);
            PBEKeySpec keySpec = (PBEKeySpec)keyFactory.getKeySpec(keystoreEntry.getSecretKey(), PBEKeySpec.class);
            char[] chars = keySpec.getPassword();
            keySpec.clearPassword();
            if (settingType == EntryType.STRING) {
                ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(chars));
                bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
                Arrays.fill(byteBuffer.array(), (byte)0);
            } else {
                assert (settingType == EntryType.FILE);
                byte[] tmpBytes = new byte[chars.length];
                for (int i = 0; i < tmpBytes.length; ++i) {
                    tmpBytes[i] = (byte)chars[i];
                }
                bytes = Base64.getDecoder().decode(tmpBytes);
                Arrays.fill(tmpBytes, (byte)0);
            }
            Arrays.fill(chars, '\u0000');
            this.entries.get().put(setting, new Entry(bytes));
        }
    }

    public synchronized void save(Path configDir, char[] password) throws Exception {
        this.ensureOpen();
        SimpleFSDirectory directory = new SimpleFSDirectory(configDir);
        String tmpFile = "elasticsearch.keystore.tmp";
        try (IndexOutput output = directory.createOutput(tmpFile, IOContext.DEFAULT);){
            CodecUtil.writeHeader(output, KEYSTORE_FILENAME, 4);
            output.writeByte(password.length == 0 ? (byte)0 : 1);
            SecureRandom random = Randomness.createSecure();
            byte[] salt = new byte[64];
            random.nextBytes(salt);
            byte[] iv = new byte[12];
            random.nextBytes(iv);
            byte[] encryptedBytes = this.encrypt(password, salt, iv);
            output.writeInt(4 + salt.length + 4 + iv.length + 4 + encryptedBytes.length);
            output.writeInt(salt.length);
            output.writeBytes(salt, salt.length);
            output.writeInt(iv.length);
            output.writeBytes(iv, iv.length);
            output.writeInt(encryptedBytes.length);
            output.writeBytes(encryptedBytes, encryptedBytes.length);
            CodecUtil.writeFooter(output);
        }
        catch (AccessDeniedException e) {
            String message = String.format(Locale.ROOT, "unable to create temporary keystore at [%s], write permissions required for [%s] or run [elasticsearch-keystore upgrade]", configDir.resolve(tmpFile), configDir);
            throw new UserException(78, message, e);
        }
        Path keystoreFile = KeyStoreWrapper.keystorePath(configDir);
        Files.move(configDir.resolve(tmpFile), keystoreFile, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        PosixFileAttributeView attrs = Files.getFileAttributeView(keystoreFile, PosixFileAttributeView.class, new LinkOption[0]);
        if (attrs != null) {
            attrs.setPermissions(PosixFilePermissions.fromString("rw-rw----"));
        }
    }

    @Override
    public Set<String> getSettingNames() {
        assert (this.entries.get() != null) : "Keystore is not loaded";
        return this.entries.get().keySet();
    }

    @Override
    public synchronized SecureString getString(String setting) {
        this.ensureOpen();
        Entry entry = this.entries.get().get(setting);
        ByteBuffer byteBuffer = ByteBuffer.wrap(entry.bytes);
        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(byteBuffer);
        return new SecureString(Arrays.copyOfRange(charBuffer.array(), charBuffer.position(), charBuffer.limit()));
    }

    @Override
    public synchronized InputStream getFile(String setting) {
        this.ensureOpen();
        Entry entry = this.entries.get().get(setting);
        return new ByteArrayInputStream(entry.bytes);
    }

    @Override
    public byte[] getSHA256Digest(String setting) {
        assert (this.entries.get() != null) : "Keystore is not loaded";
        Entry entry = this.entries.get().get(setting);
        return entry.sha256Digest;
    }

    public static void validateSettingName(String setting) {
        if (!ALLOWED_SETTING_NAME.matcher(setting).matches()) {
            throw new IllegalArgumentException("Setting name [" + setting + "] does not match the allowed setting name pattern [" + ALLOWED_SETTING_NAME.pattern() + "]");
        }
    }

    synchronized void setString(String setting, char[] value) {
        this.ensureOpen();
        KeyStoreWrapper.validateSettingName(setting);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(value));
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Entry oldEntry = this.entries.get().put(setting, new Entry(bytes));
        if (oldEntry != null) {
            Arrays.fill(oldEntry.bytes, (byte)0);
        }
    }

    synchronized void setFile(String setting, byte[] bytes) {
        this.ensureOpen();
        KeyStoreWrapper.validateSettingName(setting);
        Entry oldEntry = this.entries.get().put(setting, new Entry(Arrays.copyOf(bytes, bytes.length)));
        if (oldEntry != null) {
            Arrays.fill(oldEntry.bytes, (byte)0);
        }
    }

    void remove(String setting) {
        this.ensureOpen();
        Entry oldEntry = this.entries.get().remove(setting);
        if (oldEntry != null) {
            Arrays.fill(oldEntry.bytes, (byte)0);
        }
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new IllegalStateException("Keystore is closed");
        }
        assert (this.isLoaded()) : "Keystore is not loaded";
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        if (null != this.entries.get() && !this.entries.get().isEmpty()) {
            for (Entry entry : this.entries.get().values()) {
                Arrays.fill(entry.bytes, (byte)0);
            }
        }
    }

    private static class Entry {
        final byte[] bytes;
        final byte[] sha256Digest;

        Entry(byte[] bytes) {
            this.bytes = bytes;
            this.sha256Digest = MessageDigests.sha256().digest(bytes);
        }
    }

    private static enum EntryType {
        STRING,
        FILE;

    }
}

