/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.rounding;

import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.joda.Joda;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;

public enum DateTimeUnit {
    WEEK_OF_WEEKYEAR(1, tz -> ISOChronology.getInstance((DateTimeZone)tz).weekOfWeekyear()),
    YEAR_OF_CENTURY(2, tz -> ISOChronology.getInstance((DateTimeZone)tz).yearOfCentury()),
    QUARTER(3, tz -> Joda.QuarterOfYear.getField((Chronology)ISOChronology.getInstance((DateTimeZone)tz))),
    MONTH_OF_YEAR(4, tz -> ISOChronology.getInstance((DateTimeZone)tz).monthOfYear()),
    DAY_OF_MONTH(5, tz -> ISOChronology.getInstance((DateTimeZone)tz).dayOfMonth()),
    HOUR_OF_DAY(6, tz -> ISOChronology.getInstance((DateTimeZone)tz).hourOfDay()),
    MINUTES_OF_HOUR(7, tz -> ISOChronology.getInstance((DateTimeZone)tz).minuteOfHour()),
    SECOND_OF_MINUTE(8, tz -> ISOChronology.getInstance((DateTimeZone)tz).secondOfMinute());

    private final byte id;
    private final Function<DateTimeZone, DateTimeField> fieldFunction;

    private DateTimeUnit(byte id, Function<DateTimeZone, DateTimeField> fieldFunction) {
        this.id = id;
        this.fieldFunction = fieldFunction;
    }

    public byte id() {
        return this.id;
    }

    public DateTimeField field(DateTimeZone tz) {
        return this.fieldFunction.apply(tz);
    }

    public static DateTimeUnit resolve(byte id) {
        switch (id) {
            case 1: {
                return WEEK_OF_WEEKYEAR;
            }
            case 2: {
                return YEAR_OF_CENTURY;
            }
            case 3: {
                return QUARTER;
            }
            case 4: {
                return MONTH_OF_YEAR;
            }
            case 5: {
                return DAY_OF_MONTH;
            }
            case 6: {
                return HOUR_OF_DAY;
            }
            case 7: {
                return MINUTES_OF_HOUR;
            }
            case 8: {
                return SECOND_OF_MINUTE;
            }
        }
        throw new ElasticsearchException("Unknown date time unit id [" + id + "]", new Object[0]);
    }
}

