/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.common.TimeUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.DestConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.SettingsConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.SourceConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.SyncConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.pivot.PivotConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;

public class TransformConfig
implements ToXContentObject {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField SOURCE = new ParseField("source", new String[0]);
    public static final ParseField DEST = new ParseField("dest", new String[0]);
    public static final ParseField FREQUENCY = new ParseField("frequency", new String[0]);
    public static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    public static final ParseField SYNC = new ParseField("sync", new String[0]);
    public static final ParseField SETTINGS = new ParseField("settings", new String[0]);
    public static final ParseField VERSION = new ParseField("version", new String[0]);
    public static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    public static final ParseField PIVOT_TRANSFORM = new ParseField("pivot", new String[0]);
    private final String id;
    private final SourceConfig source;
    private final DestConfig dest;
    private final TimeValue frequency;
    private final SyncConfig syncConfig;
    private final SettingsConfig settings;
    private final PivotConfig pivotConfig;
    private final String description;
    private final Version transformVersion;
    private final Instant createTime;
    public static final ConstructingObjectParser<TransformConfig, Void> PARSER = new ConstructingObjectParser("transform", true, args -> {
        String id = (String)args[0];
        SourceConfig source = (SourceConfig)args[1];
        DestConfig dest = (DestConfig)args[2];
        TimeValue frequency = (TimeValue)args[3];
        SyncConfig syncConfig = (SyncConfig)args[4];
        PivotConfig pivotConfig = (PivotConfig)args[5];
        String description = (String)args[6];
        SettingsConfig settings = (SettingsConfig)args[7];
        Instant createTime = (Instant)args[8];
        String transformVersion = (String)args[9];
        return new TransformConfig(id, source, dest, frequency, syncConfig, pivotConfig, description, settings, createTime, transformVersion);
    });

    private static SyncConfig parseSyncConfig(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser);
        SyncConfig syncConfig = parser.namedObject(SyncConfig.class, parser.currentName(), true);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser);
        return syncConfig;
    }

    public static TransformConfig fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public static TransformConfig forPreview(SourceConfig source, PivotConfig pivotConfig) {
        return new TransformConfig(null, source, null, null, null, pivotConfig, null, null, null, null);
    }

    TransformConfig(String id, SourceConfig source, DestConfig dest, TimeValue frequency, SyncConfig syncConfig, PivotConfig pivotConfig, String description, SettingsConfig settings, Instant createTime, String version) {
        this.id = id;
        this.source = source;
        this.dest = dest;
        this.frequency = frequency;
        this.syncConfig = syncConfig;
        this.pivotConfig = pivotConfig;
        this.description = description;
        this.settings = settings;
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.transformVersion = version == null ? null : Version.fromString(version);
    }

    public String getId() {
        return this.id;
    }

    public SourceConfig getSource() {
        return this.source;
    }

    public DestConfig getDestination() {
        return this.dest;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public SyncConfig getSyncConfig() {
        return this.syncConfig;
    }

    public PivotConfig getPivotConfig() {
        return this.pivotConfig;
    }

    public Version getVersion() {
        return this.transformVersion;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SettingsConfig getSettings() {
        return this.settings;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.id != null) {
            builder.field(ID.getPreferredName(), this.id);
        }
        if (this.source != null) {
            builder.field(SOURCE.getPreferredName(), this.source);
        }
        if (this.dest != null) {
            builder.field(DEST.getPreferredName(), this.dest);
        }
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        if (this.syncConfig != null) {
            builder.startObject(SYNC.getPreferredName());
            builder.field(this.syncConfig.getName(), this.syncConfig);
            builder.endObject();
        }
        if (this.pivotConfig != null) {
            builder.field(PIVOT_TRANSFORM.getPreferredName(), this.pivotConfig);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION.getPreferredName(), this.description);
        }
        if (this.settings != null) {
            builder.field(SETTINGS.getPreferredName(), this.settings);
        }
        if (this.createTime != null) {
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        if (this.transformVersion != null) {
            builder.field(VERSION.getPreferredName(), this.transformVersion);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformConfig that = (TransformConfig)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.source, that.source) && Objects.equals(this.dest, that.dest) && Objects.equals(this.frequency, that.frequency) && Objects.equals(this.description, that.description) && Objects.equals(this.syncConfig, that.syncConfig) && Objects.equals(this.transformVersion, that.transformVersion) && Objects.equals(this.settings, that.settings) && Objects.equals(this.createTime, that.createTime) && Objects.equals(this.pivotConfig, that.pivotConfig);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.settings, this.createTime, this.transformVersion, this.pivotConfig, this.description);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> SourceConfig.PARSER.apply(p, null), SOURCE);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DestConfig.PARSER.apply(p, null), DEST);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeValue.parseTimeValue(p.text(), FREQUENCY.getPreferredName()), FREQUENCY, ObjectParser.ValueType.STRING);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TransformConfig.parseSyncConfig(p), SYNC);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> PivotConfig.fromXContent(p), PIVOT_TRANSFORM);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), DESCRIPTION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> SettingsConfig.fromXContent(p), SETTINGS);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), VERSION);
    }

    public static class Builder {
        private String id;
        private SourceConfig source;
        private DestConfig dest;
        private TimeValue frequency;
        private SyncConfig syncConfig;
        private PivotConfig pivotConfig;
        private SettingsConfig settings;
        private String description;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setSource(SourceConfig source) {
            this.source = source;
            return this;
        }

        public Builder setDest(DestConfig dest) {
            this.dest = dest;
            return this;
        }

        public Builder setFrequency(TimeValue frequency) {
            this.frequency = frequency;
            return this;
        }

        public Builder setSyncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public Builder setPivotConfig(PivotConfig pivotConfig) {
            this.pivotConfig = pivotConfig;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSettings(SettingsConfig settings) {
            this.settings = settings;
            return this;
        }

        public TransformConfig build() {
            return new TransformConfig(this.id, this.source, this.dest, this.frequency, this.syncConfig, this.pivotConfig, this.description, this.settings, null, null);
        }
    }
}

