/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.SyncConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class TimeSyncConfig
implements SyncConfig {
    public static final String NAME = "time";
    private static final ParseField FIELD = new ParseField("field", new String[0]);
    private static final ParseField DELAY = new ParseField("delay", new String[0]);
    private final String field;
    private final TimeValue delay;
    private static final ConstructingObjectParser<TimeSyncConfig, Void> PARSER = new ConstructingObjectParser("time_sync_config", true, args -> new TimeSyncConfig((String)args[0], args[1] != null ? (TimeValue)args[1] : TimeValue.ZERO));

    public static TimeSyncConfig fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public TimeSyncConfig(String field, TimeValue delay) {
        this.field = field;
        this.delay = delay;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FIELD.getPreferredName(), this.field);
        if (this.delay.duration() > 0L) {
            builder.field(DELAY.getPreferredName(), this.delay.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public String getField() {
        return this.field;
    }

    public TimeValue getDelay() {
        return this.delay;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TimeSyncConfig that = (TimeSyncConfig)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.delay);
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TimeValue.parseTimeValue(p.textOrNull(), DELAY.getPreferredName()), DELAY, ObjectParser.ValueType.STRING_OR_NULL);
    }
}

