/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public final class GetBuiltinPrivilegesResponse {
    private final Set<String> clusterPrivileges;
    private final Set<String> indexPrivileges;
    private static final ConstructingObjectParser<GetBuiltinPrivilegesResponse, Void> PARSER = new ConstructingObjectParser("get_builtin_privileges", true, args -> new GetBuiltinPrivilegesResponse((Collection)args[0], (Collection)args[1]));

    public GetBuiltinPrivilegesResponse(Collection<String> cluster, Collection<String> index) {
        this.clusterPrivileges = Collections.unmodifiableSet(new HashSet<String>(cluster));
        this.indexPrivileges = Collections.unmodifiableSet(new HashSet<String>(index));
    }

    public Set<String> getClusterPrivileges() {
        return this.clusterPrivileges;
    }

    public Set<String> getIndexPrivileges() {
        return this.indexPrivileges;
    }

    public static GetBuiltinPrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetBuiltinPrivilegesResponse that = (GetBuiltinPrivilegesResponse)o;
        return Objects.equals(this.clusterPrivileges, that.clusterPrivileges) && Objects.equals(this.indexPrivileges, that.indexPrivileges);
    }

    public int hashCode() {
        return Objects.hash(this.clusterPrivileges, this.indexPrivileges);
    }

    static {
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("cluster", new String[0]));
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), new ParseField("index", new String[0]));
    }
}

