/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.rollup.RollableIndexCaps;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class GetRollupCapsResponse {
    private final Map<String, RollableIndexCaps> jobs;

    public GetRollupCapsResponse(Map<String, RollableIndexCaps> jobs) {
        this.jobs = Collections.unmodifiableMap(Objects.requireNonNull(jobs));
    }

    public Map<String, RollableIndexCaps> getJobs() {
        return this.jobs;
    }

    public static GetRollupCapsResponse fromXContent(XContentParser parser) throws IOException {
        HashMap<String, RollableIndexCaps> jobs = new HashMap<String, RollableIndexCaps>();
        XContentParser.Token token = parser.nextToken();
        if (token.equals((Object)XContentParser.Token.START_OBJECT)) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (!token.equals((Object)XContentParser.Token.FIELD_NAME)) continue;
                String pattern = parser.currentName();
                RollableIndexCaps cap = RollableIndexCaps.PARSER.parse(parser, pattern);
                jobs.put(pattern, cap);
            }
        }
        return new GetRollupCapsResponse(jobs);
    }

    public int hashCode() {
        return Objects.hash(this.jobs);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetRollupCapsResponse other = (GetRollupCapsResponse)obj;
        return Objects.equals(this.jobs, other.jobs);
    }
}

