/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.common.TimeUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.Job;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.results.AnomalyRecord;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.results.BucketInfluencer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.results.Result;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class Bucket
implements ToXContentObject {
    public static final ParseField ANOMALY_SCORE = new ParseField("anomaly_score", new String[0]);
    public static final ParseField INITIAL_ANOMALY_SCORE = new ParseField("initial_anomaly_score", new String[0]);
    public static final ParseField EVENT_COUNT = new ParseField("event_count", new String[0]);
    public static final ParseField RECORDS = new ParseField("records", new String[0]);
    public static final ParseField BUCKET_INFLUENCERS = new ParseField("bucket_influencers", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField PROCESSING_TIME_MS = new ParseField("processing_time_ms", new String[0]);
    public static final ParseField SCHEDULED_EVENTS = new ParseField("scheduled_events", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("buckets", new String[0]);
    public static final String RESULT_TYPE_VALUE = "bucket";
    public static final ParseField RESULT_TYPE_FIELD = new ParseField("bucket", new String[0]);
    public static final ConstructingObjectParser<Bucket, Void> PARSER = new ConstructingObjectParser("bucket", true, a -> new Bucket((String)a[0], (Date)a[1], (Long)a[2]));
    private final String jobId;
    private final Date timestamp;
    private final long bucketSpan;
    private double anomalyScore;
    private double initialAnomalyScore;
    private List<AnomalyRecord> records = new ArrayList<AnomalyRecord>();
    private long eventCount;
    private boolean isInterim;
    private List<BucketInfluencer> bucketInfluencers = new ArrayList<BucketInfluencer>();
    private long processingTimeMs;
    private List<String> scheduledEvents = Collections.emptyList();

    Bucket(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = Objects.requireNonNull(timestamp);
        this.bucketSpan = bucketSpan;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        builder.field(ANOMALY_SCORE.getPreferredName(), this.anomalyScore);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(INITIAL_ANOMALY_SCORE.getPreferredName(), this.initialAnomalyScore);
        if (!this.records.isEmpty()) {
            builder.field(RECORDS.getPreferredName(), this.records);
        }
        builder.field(EVENT_COUNT.getPreferredName(), this.eventCount);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.field(BUCKET_INFLUENCERS.getPreferredName(), this.bucketInfluencers);
        builder.field(PROCESSING_TIME_MS.getPreferredName(), this.processingTimeMs);
        if (!this.scheduledEvents.isEmpty()) {
            builder.field(SCHEDULED_EVENTS.getPreferredName(), this.scheduledEvents);
        }
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.endObject();
        return builder;
    }

    public String getJobId() {
        return this.jobId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getAnomalyScore() {
        return this.anomalyScore;
    }

    void setAnomalyScore(double anomalyScore) {
        this.anomalyScore = anomalyScore;
    }

    public double getInitialAnomalyScore() {
        return this.initialAnomalyScore;
    }

    void setInitialAnomalyScore(double initialAnomalyScore) {
        this.initialAnomalyScore = initialAnomalyScore;
    }

    public List<AnomalyRecord> getRecords() {
        return this.records;
    }

    void setRecords(List<AnomalyRecord> records) {
        this.records = Collections.unmodifiableList(records);
    }

    public long getEventCount() {
        return this.eventCount;
    }

    void setEventCount(long value) {
        this.eventCount = value;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    void setInterim(boolean isInterim) {
        this.isInterim = isInterim;
    }

    public long getProcessingTimeMs() {
        return this.processingTimeMs;
    }

    void setProcessingTimeMs(long timeMs) {
        this.processingTimeMs = timeMs;
    }

    public List<BucketInfluencer> getBucketInfluencers() {
        return this.bucketInfluencers;
    }

    void setBucketInfluencers(List<BucketInfluencer> bucketInfluencers) {
        this.bucketInfluencers = Collections.unmodifiableList(bucketInfluencers);
    }

    public List<String> getScheduledEvents() {
        return this.scheduledEvents;
    }

    void setScheduledEvents(List<String> scheduledEvents) {
        this.scheduledEvents = Collections.unmodifiableList(scheduledEvents);
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.timestamp, this.eventCount, this.initialAnomalyScore, this.anomalyScore, this.records, this.isInterim, this.bucketSpan, this.bucketInfluencers, this.processingTimeMs, this.scheduledEvents);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Bucket that = (Bucket)other;
        return Objects.equals(this.jobId, that.jobId) && Objects.equals(this.timestamp, that.timestamp) && this.eventCount == that.eventCount && this.bucketSpan == that.bucketSpan && this.anomalyScore == that.anomalyScore && this.initialAnomalyScore == that.initialAnomalyScore && Objects.equals(this.records, that.records) && Objects.equals(this.isInterim, that.isInterim) && Objects.equals(this.bucketInfluencers, that.bucketInfluencers) && this.processingTimeMs == that.processingTimeMs && Objects.equals(this.scheduledEvents, that.scheduledEvents);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        PARSER.declareDouble(Bucket::setAnomalyScore, ANOMALY_SCORE);
        PARSER.declareDouble(Bucket::setInitialAnomalyScore, INITIAL_ANOMALY_SCORE);
        PARSER.declareBoolean(Bucket::setInterim, Result.IS_INTERIM);
        PARSER.declareLong(Bucket::setEventCount, EVENT_COUNT);
        PARSER.declareObjectArray(Bucket::setRecords, AnomalyRecord.PARSER, RECORDS);
        PARSER.declareObjectArray(Bucket::setBucketInfluencers, BucketInfluencer.PARSER, BUCKET_INFLUENCERS);
        PARSER.declareLong(Bucket::setProcessingTimeMs, PROCESSING_TIME_MS);
        PARSER.declareString((bucket, s) -> {}, Result.RESULT_TYPE);
        PARSER.declareStringArray(Bucket::setScheduledEvents, SCHEDULED_EVENTS);
    }
}

