/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference.NamedXContentObjectHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference.preprocessing.PreProcessor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.inference.trainedmodel.TrainedModel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class TrainedModelDefinition
implements ToXContentObject {
    public static final String NAME = "trained_model_doc";
    public static final ParseField TRAINED_MODEL = new ParseField("trained_model", new String[0]);
    public static final ParseField PREPROCESSORS = new ParseField("preprocessors", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("trained_model_doc", true, Builder::new);
    private final TrainedModel trainedModel;
    private final List<PreProcessor> preProcessors;

    public static Builder fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    TrainedModelDefinition(TrainedModel trainedModel, List<PreProcessor> preProcessors) {
        this.trainedModel = trainedModel;
        this.preProcessors = preProcessors == null ? Collections.emptyList() : Collections.unmodifiableList(preProcessors);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        NamedXContentObjectHelper.writeNamedObjects(builder, params, false, TRAINED_MODEL.getPreferredName(), Collections.singletonList(this.trainedModel));
        NamedXContentObjectHelper.writeNamedObjects(builder, params, true, PREPROCESSORS.getPreferredName(), this.preProcessors);
        builder.endObject();
        return builder;
    }

    public TrainedModel getTrainedModel() {
        return this.trainedModel;
    }

    public List<PreProcessor> getPreProcessors() {
        return this.preProcessors;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrainedModelDefinition that = (TrainedModelDefinition)o;
        return Objects.equals(this.trainedModel, that.trainedModel) && Objects.equals(this.preProcessors, that.preProcessors);
    }

    public int hashCode() {
        return Objects.hash(this.trainedModel, this.preProcessors);
    }

    static {
        PARSER.declareNamedObject(Builder::setTrainedModel, (p, c, n) -> p.namedObject(TrainedModel.class, n, null), TRAINED_MODEL);
        PARSER.declareNamedObjects(Builder::setPreProcessors, (p, c, n) -> p.namedObject(PreProcessor.class, n, null), trainedModelDefBuilder -> {}, PREPROCESSORS);
    }

    public static class Builder {
        private List<PreProcessor> preProcessors;
        private TrainedModel trainedModel;

        public Builder setPreProcessors(List<PreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder setTrainedModel(TrainedModel trainedModel) {
            this.trainedModel = trainedModel;
            return this;
        }

        public TrainedModelDefinition build() {
            return new TrainedModelDefinition(this.trainedModel, this.preProcessors);
        }
    }
}

