/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.regression;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.common.TimeUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.AnalysisStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.regression.Hyperparameters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.regression.TimingStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.regression.ValidationLoss;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class RegressionStats
implements AnalysisStats {
    public static final ParseField NAME = new ParseField("regression_stats", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField ITERATION = new ParseField("iteration", new String[0]);
    public static final ParseField HYPERPARAMETERS = new ParseField("hyperparameters", new String[0]);
    public static final ParseField TIMING_STATS = new ParseField("timing_stats", new String[0]);
    public static final ParseField VALIDATION_LOSS = new ParseField("validation_loss", new String[0]);
    public static final ConstructingObjectParser<RegressionStats, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new RegressionStats((Instant)a[0], (Integer)a[1], (Hyperparameters)a[2], (TimingStats)a[3], (ValidationLoss)a[4]));
    private final Instant timestamp;
    private final Integer iteration;
    private final Hyperparameters hyperparameters;
    private final TimingStats timingStats;
    private final ValidationLoss validationLoss;

    public RegressionStats(Instant timestamp, Integer iteration, Hyperparameters hyperparameters, TimingStats timingStats, ValidationLoss validationLoss) {
        this.timestamp = Instant.ofEpochMilli(Objects.requireNonNull(timestamp).toEpochMilli());
        this.iteration = iteration;
        this.hyperparameters = Objects.requireNonNull(hyperparameters);
        this.timingStats = Objects.requireNonNull(timingStats);
        this.validationLoss = Objects.requireNonNull(validationLoss);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Integer getIteration() {
        return this.iteration;
    }

    public Hyperparameters getHyperparameters() {
        return this.hyperparameters;
    }

    public TimingStats getTimingStats() {
        return this.timingStats;
    }

    public ValidationLoss getValidationLoss() {
        return this.validationLoss;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        if (this.iteration != null) {
            builder.field(ITERATION.getPreferredName(), this.iteration);
        }
        builder.field(HYPERPARAMETERS.getPreferredName(), this.hyperparameters);
        builder.field(TIMING_STATS.getPreferredName(), this.timingStats);
        builder.field(VALIDATION_LOSS.getPreferredName(), this.validationLoss);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegressionStats that = (RegressionStats)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.iteration, that.iteration) && Objects.equals(this.hyperparameters, that.hyperparameters) && Objects.equals(this.timingStats, that.timingStats) && Objects.equals(this.validationLoss, that.validationLoss);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.iteration, this.hyperparameters, this.timingStats, this.validationLoss);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), ITERATION);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Hyperparameters.PARSER, HYPERPARAMETERS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TimingStats.PARSER, TIMING_STATS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), ValidationLoss.PARSER, VALIDATION_LOSS);
    }
}

