/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class RecallMetric
implements EvaluationMetric {
    public static final String NAME = "recall";
    private static final ObjectParser<RecallMetric, Void> PARSER = new ObjectParser("recall", true, RecallMetric::new);

    public static RecallMetric fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return Objects.hashCode(NAME);
    }

    public static class PerClassResult
    implements ToXContentObject {
        private static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
        private static final ParseField RECALL = new ParseField("recall", new String[0]);
        private static final ConstructingObjectParser<PerClassResult, Void> PARSER = new ConstructingObjectParser("recall_per_class_result", true, a -> new PerClassResult((String)a[0], (Double)a[1]));
        private final String className;
        private final double recall;

        public PerClassResult(String className, double recall) {
            this.className = Objects.requireNonNull(className);
            this.recall = recall;
        }

        public String getClassName() {
            return this.className;
        }

        public double getRecall() {
            return this.recall;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASS_NAME.getPreferredName(), this.className);
            builder.field(RECALL.getPreferredName(), this.recall);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerClassResult that = (PerClassResult)o;
            return Objects.equals(this.className, that.className) && this.recall == that.recall;
        }

        public int hashCode() {
            return Objects.hash(this.className, this.recall);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), CLASS_NAME);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), RECALL);
        }
    }

    public static class Result
    implements EvaluationMetric.Result {
        private static final ParseField CLASSES = new ParseField("classes", new String[0]);
        private static final ParseField AVG_RECALL = new ParseField("avg_recall", new String[0]);
        private static final ConstructingObjectParser<Result, Void> PARSER = new ConstructingObjectParser("recall_result", true, a -> new Result((List)a[0], (Double)a[1]));
        private final List<PerClassResult> classes;
        private final double avgRecall;

        public static Result fromXContent(XContentParser parser) {
            return PARSER.apply(parser, null);
        }

        public Result(List<PerClassResult> classes, double avgRecall) {
            this.classes = Collections.unmodifiableList(Objects.requireNonNull(classes));
            this.avgRecall = avgRecall;
        }

        @Override
        public String getMetricName() {
            return RecallMetric.NAME;
        }

        public List<PerClassResult> getClasses() {
            return this.classes;
        }

        public double getAvgRecall() {
            return this.avgRecall;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CLASSES.getPreferredName(), this.classes);
            builder.field(AVG_RECALL.getPreferredName(), this.avgRecall);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.classes, that.classes) && this.avgRecall == that.avgRecall;
        }

        public int hashCode() {
            return Objects.hash(this.classes, this.avgRecall);
        }

        static {
            PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), PerClassResult.PARSER, CLASSES);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), AVG_RECALL);
        }
    }
}

