/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameAnalyticsDest
implements ToXContentObject {
    private static final ParseField INDEX = new ParseField("index", new String[0]);
    private static final ParseField RESULTS_FIELD = new ParseField("results_field", new String[0]);
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_dest", true, () -> new Builder());
    private final String index;
    private final String resultsField;

    public static DataFrameAnalyticsDest fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private DataFrameAnalyticsDest(String index, @Nullable String resultsField) {
        this.index = Objects.requireNonNull(index);
        this.resultsField = resultsField;
    }

    public String getIndex() {
        return this.index;
    }

    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX.getPreferredName(), this.index);
        if (this.resultsField != null) {
            builder.field(RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsDest other = (DataFrameAnalyticsDest)o;
        return Objects.equals(this.index, other.index) && Objects.equals(this.resultsField, other.resultsField);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.resultsField);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(Builder::setIndex, INDEX);
        PARSER.declareString(Builder::setResultsField, RESULTS_FIELD);
    }

    public static class Builder {
        private String index;
        private String resultsField;

        private Builder() {
        }

        public Builder setIndex(String index) {
            this.index = index;
            return this;
        }

        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public DataFrameAnalyticsDest build() {
            return new DataFrameAnalyticsDest(this.index, this.resultsField);
        }
    }
}

