/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.Job;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetOverallBucketsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField TOP_N = new ParseField("top_n", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField OVERALL_SCORE = new ParseField("overall_score", new String[0]);
    public static final ParseField EXCLUDE_INTERIM = new ParseField("exclude_interim", new String[0]);
    public static final ParseField START = new ParseField("start", new String[0]);
    public static final ParseField END = new ParseField("end", new String[0]);
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    private static final String ALL_JOBS = "_all";
    public static final ConstructingObjectParser<GetOverallBucketsRequest, Void> PARSER = new ConstructingObjectParser("get_overall_buckets_request", a -> new GetOverallBucketsRequest((String)a[0]));
    private final List<String> jobIds;
    private Integer topN;
    private TimeValue bucketSpan;
    private Boolean excludeInterim;
    private Double overallScore;
    private String start;
    private String end;
    private Boolean allowNoMatch;

    private GetOverallBucketsRequest(String jobId) {
        this(Strings.tokenizeToStringArray(jobId, ","));
    }

    public GetOverallBucketsRequest(String ... jobIds) {
        this(Arrays.asList(jobIds));
    }

    public GetOverallBucketsRequest(List<String> jobIds) {
        if (jobIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("jobIds must not contain null values");
        }
        this.jobIds = jobIds.isEmpty() ? Collections.singletonList(ALL_JOBS) : Collections.unmodifiableList(jobIds);
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public Integer getTopN() {
        return this.topN;
    }

    public void setTopN(Integer topN) {
        this.topN = topN;
    }

    public TimeValue getBucketSpan() {
        return this.bucketSpan;
    }

    public void setBucketSpan(TimeValue bucketSpan) {
        this.bucketSpan = bucketSpan;
    }

    private void setBucketSpan(String bucketSpan) {
        this.bucketSpan = TimeValue.parseTimeValue(bucketSpan, BUCKET_SPAN.getPreferredName());
    }

    public boolean isExcludeInterim() {
        return this.excludeInterim;
    }

    public void setExcludeInterim(Boolean excludeInterim) {
        this.excludeInterim = excludeInterim;
    }

    public String getStart() {
        return this.start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public String getEnd() {
        return this.end;
    }

    public void setEnd(String end) {
        this.end = end;
    }

    public Double getOverallScore() {
        return this.overallScore;
    }

    public void setOverallScore(double overallScore) {
        this.overallScore = overallScore;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (!this.jobIds.isEmpty()) {
            builder.field(Job.ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.jobIds));
        }
        if (this.topN != null) {
            builder.field(TOP_N.getPreferredName(), this.topN);
        }
        if (this.bucketSpan != null) {
            builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan.getStringRep());
        }
        if (this.excludeInterim != null) {
            builder.field(EXCLUDE_INTERIM.getPreferredName(), this.excludeInterim);
        }
        if (this.start != null) {
            builder.field(START.getPreferredName(), this.start);
        }
        if (this.end != null) {
            builder.field(END.getPreferredName(), this.end);
        }
        if (this.overallScore != null) {
            builder.field(OVERALL_SCORE.getPreferredName(), this.overallScore);
        }
        if (this.allowNoMatch != null) {
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.jobIds, this.topN, this.bucketSpan, this.excludeInterim, this.overallScore, this.start, this.end, this.allowNoMatch);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GetOverallBucketsRequest other = (GetOverallBucketsRequest)obj;
        return Objects.equals(this.jobIds, other.jobIds) && Objects.equals(this.topN, other.topN) && Objects.equals(this.bucketSpan, other.bucketSpan) && Objects.equals(this.excludeInterim, other.excludeInterim) && Objects.equals(this.overallScore, other.overallScore) && Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        PARSER.declareInt(GetOverallBucketsRequest::setTopN, TOP_N);
        PARSER.declareString(GetOverallBucketsRequest::setBucketSpan, BUCKET_SPAN);
        PARSER.declareBoolean(GetOverallBucketsRequest::setExcludeInterim, EXCLUDE_INTERIM);
        PARSER.declareDouble(GetOverallBucketsRequest::setOverallScore, OVERALL_SCORE);
        PARSER.declareStringOrNull(GetOverallBucketsRequest::setStart, START);
        PARSER.declareStringOrNull(GetOverallBucketsRequest::setEnd, END);
        PARSER.declareBoolean(GetOverallBucketsRequest::setAllowNoMatch, ALLOW_NO_MATCH);
    }
}

