/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.job.config.Job;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class GetJobStatsRequest
extends ActionRequest
implements ToXContentObject {
    public static final ParseField ALLOW_NO_MATCH = new ParseField("allow_no_match", new String[0]);
    public static final ConstructingObjectParser<GetJobStatsRequest, Void> PARSER = new ConstructingObjectParser("get_jobs_stats_request", a -> new GetJobStatsRequest((List)a[0]));
    private static final String ALL_JOBS = "_all";
    private final List<String> jobIds;
    private Boolean allowNoMatch;

    public static GetJobStatsRequest getAllJobStatsRequest() {
        return new GetJobStatsRequest(ALL_JOBS);
    }

    GetJobStatsRequest(List<String> jobIds) {
        if (jobIds.stream().anyMatch(Objects::isNull)) {
            throw new NullPointerException("jobIds must not contain null values");
        }
        this.jobIds = new ArrayList<String>(jobIds);
    }

    public GetJobStatsRequest(String ... jobIds) {
        this(Arrays.asList(jobIds));
    }

    public List<String> getJobIds() {
        return this.jobIds;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public int hashCode() {
        return Objects.hash(this.jobIds, this.allowNoMatch);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetJobStatsRequest that = (GetJobStatsRequest)other;
        return Objects.equals(this.jobIds, that.jobIds) && Objects.equals(this.allowNoMatch, that.allowNoMatch);
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), Strings.collectionToCommaDelimitedString(this.jobIds));
        if (this.allowNoMatch != null) {
            builder.field(ALLOW_NO_MATCH.getPreferredName(), this.allowNoMatch);
        }
        builder.endObject();
        return builder;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> Arrays.asList(Strings.commaDelimitedListToStringArray(p.text())), Job.ID, ObjectParser.ValueType.STRING_ARRAY);
        PARSER.declareBoolean(GetJobStatsRequest::setAllowNoMatch, ALLOW_NO_MATCH);
    }
}

